/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import jakarta.persistence.EntityManager;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.data.jpa.repository.query.AbstractJpaQuery;
import org.springframework.data.jpa.repository.query.DeclaredQuery;
import org.springframework.data.jpa.repository.query.JpaQueryConfiguration;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.jpa.repository.query.JpaQueryMethodFactory;
import org.springframework.data.jpa.repository.query.NamedQuery;
import org.springframework.data.jpa.repository.query.NativeJpaQuery;
import org.springframework.data.jpa.repository.query.PartTreeJpaQuery;
import org.springframework.data.jpa.repository.query.SimpleJpaQuery;
import org.springframework.data.jpa.repository.query.StoredProcedureJpaQuery;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryCreationException;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class JpaQueryLookupStrategy {
    private static final Log LOG = LogFactory.getLog(JpaQueryLookupStrategy.class);
    private static final RepositoryQuery NO_QUERY = new NoQuery();

    private JpaQueryLookupStrategy() {
    }

    public static QueryLookupStrategy create(EntityManager em, JpaQueryMethodFactory queryMethodFactory, // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable QueryLookupStrategy.Key key, JpaQueryConfiguration configuration) {
        Assert.notNull((Object)em, (String)"EntityManager must not be null");
        Assert.notNull((Object)configuration, (String)"JpaQueryConfiguration must not be null");
        return switch (key != null ? key : QueryLookupStrategy.Key.CREATE_IF_NOT_FOUND) {
            case QueryLookupStrategy.Key.CREATE -> new CreateQueryLookupStrategy(em, queryMethodFactory, configuration);
            case QueryLookupStrategy.Key.USE_DECLARED_QUERY -> new DeclaredQueryLookupStrategy(em, queryMethodFactory, configuration);
            case QueryLookupStrategy.Key.CREATE_IF_NOT_FOUND -> new CreateIfNotFoundQueryLookupStrategy(em, queryMethodFactory, new CreateQueryLookupStrategy(em, queryMethodFactory, configuration), new DeclaredQueryLookupStrategy(em, queryMethodFactory, configuration), configuration);
            default -> throw new IllegalArgumentException(String.format("Unsupported query lookup strategy %s", key));
        };
    }

    private static abstract class AbstractQueryLookupStrategy
    implements QueryLookupStrategy {
        private final EntityManager em;
        private final JpaQueryMethodFactory queryMethodFactory;
        private final JpaQueryConfiguration configuration;

        public AbstractQueryLookupStrategy(EntityManager em, JpaQueryMethodFactory queryMethodFactory, JpaQueryConfiguration configuration) {
            this.em = em;
            this.queryMethodFactory = queryMethodFactory;
            this.configuration = configuration;
        }

        public final RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory factory, NamedQueries namedQueries) {
            JpaQueryMethod queryMethod = this.queryMethodFactory.build(method, metadata, factory);
            return this.resolveQuery(queryMethod, this.configuration, this.em, namedQueries);
        }

        protected abstract RepositoryQuery resolveQuery(JpaQueryMethod var1, JpaQueryConfiguration var2, EntityManager var3, NamedQueries var4);
    }

    private static class CreateIfNotFoundQueryLookupStrategy
    extends AbstractQueryLookupStrategy {
        private final DeclaredQueryLookupStrategy lookupStrategy;
        private final CreateQueryLookupStrategy createStrategy;

        public CreateIfNotFoundQueryLookupStrategy(EntityManager em, JpaQueryMethodFactory queryMethodFactory, CreateQueryLookupStrategy createStrategy, DeclaredQueryLookupStrategy lookupStrategy, JpaQueryConfiguration configuration) {
            super(em, queryMethodFactory, configuration);
            this.createStrategy = createStrategy;
            this.lookupStrategy = lookupStrategy;
        }

        @Override
        protected RepositoryQuery resolveQuery(JpaQueryMethod method, JpaQueryConfiguration configuration, EntityManager em, NamedQueries namedQueries) {
            RepositoryQuery lookupQuery = this.lookupStrategy.resolveQuery(method, configuration, em, namedQueries);
            if (lookupQuery != NO_QUERY) {
                return lookupQuery;
            }
            return this.createStrategy.resolveQuery(method, configuration, em, namedQueries);
        }
    }

    private static class CreateQueryLookupStrategy
    extends AbstractQueryLookupStrategy {
        public CreateQueryLookupStrategy(EntityManager em, JpaQueryMethodFactory queryMethodFactory, JpaQueryConfiguration configuration) {
            super(em, queryMethodFactory, configuration);
        }

        @Override
        protected RepositoryQuery resolveQuery(JpaQueryMethod method, JpaQueryConfiguration configuration, EntityManager em, NamedQueries namedQueries) {
            return new PartTreeJpaQuery(method, em, configuration.getEscapeCharacter());
        }
    }

    static class DeclaredQueryLookupStrategy
    extends AbstractQueryLookupStrategy {
        public DeclaredQueryLookupStrategy(EntityManager em, JpaQueryMethodFactory queryMethodFactory, JpaQueryConfiguration configuration) {
            super(em, queryMethodFactory, configuration);
        }

        @Override
        protected RepositoryQuery resolveQuery(JpaQueryMethod method, JpaQueryConfiguration configuration, EntityManager em, NamedQueries namedQueries) {
            if (method.isProcedureQuery()) {
                return DeclaredQueryLookupStrategy.createProcedureQuery(method, em);
            }
            if (method.hasAnnotatedQuery()) {
                if (method.hasAnnotatedQueryName()) {
                    LOG.warn((Object)String.format("Query method %s is annotated with both, a query and a query name; Using the declared query", new Object[]{method}));
                }
                return DeclaredQueryLookupStrategy.createStringQuery(method, em, method.getRequiredDeclaredQuery(), this.getCountQuery(method, namedQueries, em), configuration);
            }
            String name = method.getNamedQueryName();
            if (namedQueries.hasQuery(name)) {
                return DeclaredQueryLookupStrategy.createStringQuery(method, em, method.getDeclaredQuery(namedQueries.getQuery(name)), this.getCountQuery(method, namedQueries, em), configuration);
            }
            RepositoryQuery query = NamedQuery.lookupFrom(method, em, configuration);
            return query != null ? query : NO_QUERY;
        }

        @Nullable
        private DeclaredQuery getCountQuery(JpaQueryMethod method, NamedQueries namedQueries, EntityManager em) {
            String query = DeclaredQueryLookupStrategy.doGetCountQuery(method, namedQueries, em);
            return StringUtils.hasText((String)query) ? method.getDeclaredQuery(query) : null;
        }

        @Nullable
        private static String doGetCountQuery(JpaQueryMethod method, NamedQueries namedQueries, EntityManager em) {
            if (StringUtils.hasText((String)method.getCountQuery())) {
                return method.getCountQuery();
            }
            String queryName = method.getNamedCountQueryName();
            if (!StringUtils.hasText((String)queryName)) {
                return method.getCountQuery();
            }
            if (namedQueries.hasQuery(queryName)) {
                return namedQueries.getQuery(queryName);
            }
            boolean namedQuery = NamedQuery.hasNamedQuery(em, queryName);
            if (namedQuery) {
                return method.getQueryExtractor().extractQueryString(em.createNamedQuery(queryName));
            }
            return null;
        }

        static AbstractJpaQuery createStringQuery(JpaQueryMethod method, EntityManager em, DeclaredQuery query, @Nullable DeclaredQuery countQuery, JpaQueryConfiguration configuration) {
            if (method.isScrollQuery()) {
                throw QueryCreationException.create((QueryMethod)method, (String)"Scroll queries are not supported using String-based queries");
            }
            return method.isNativeQuery() ? new NativeJpaQuery(method, em, query, countQuery, configuration) : new SimpleJpaQuery(method, em, query, countQuery, configuration);
        }

        static StoredProcedureJpaQuery createProcedureQuery(JpaQueryMethod method, EntityManager em) {
            if (method.isScrollQuery()) {
                throw QueryCreationException.create((QueryMethod)method, (String)"Scroll queries are not supported using stored procedures");
            }
            return new StoredProcedureJpaQuery(method, em);
        }
    }

    static class NoQuery
    implements RepositoryQuery {
        NoQuery() {
        }

        public Object execute(Object[] parameters) {
            throw new IllegalStateException("NoQuery should not be executed!");
        }

        public QueryMethod getQueryMethod() {
            throw new IllegalStateException("NoQuery does not have a QueryMethod!");
        }
    }
}

