/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.aot;

import jakarta.persistence.Entity;
import jakarta.persistence.EntityManagerFactory;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.data.jpa.repository.EntityGraph;
import org.springframework.data.jpa.repository.aot.AotEntityGraph;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.util.StringUtils;

record EntityGraphLookup(EntityManagerFactory entityManagerFactory) {
    @Nullable
    public AotEntityGraph findEntityGraph(MergedAnnotation<EntityGraph> entityGraph, RepositoryInformation information, ReturnedType returnedType, JpaQueryMethod queryMethod) {
        if (!entityGraph.isPresent()) {
            return null;
        }
        EntityGraph.EntityGraphType type = (EntityGraph.EntityGraphType)entityGraph.getEnum("type", EntityGraph.EntityGraphType.class);
        String[] attributePaths = entityGraph.getStringArray("attributePaths");
        Set<String> entityGraphNames = this.getEntityGraphNames(entityGraph, information, queryMethod);
        List<Class> candidates = Arrays.asList(returnedType.getDomainType(), returnedType.getReturnedType(), returnedType.getTypeToRead());
        for (Class candidate : candidates) {
            Map namedEntityGraphs = this.entityManagerFactory.getNamedEntityGraphs((Class)Class.class.cast(candidate));
            if (namedEntityGraphs.isEmpty()) continue;
            for (String entityGraphName : entityGraphNames) {
                if (!namedEntityGraphs.containsKey(entityGraphName)) continue;
                return new AotEntityGraph(entityGraphName, type, Collections.emptyList());
            }
        }
        if (attributePaths.length > 0) {
            return new AotEntityGraph(null, type, Arrays.asList(attributePaths));
        }
        return null;
    }

    private Set<String> getEntityGraphNames(MergedAnnotation<EntityGraph> entityGraph, RepositoryInformation information, JpaQueryMethod queryMethod) {
        LinkedHashSet<String> entityGraphNames = new LinkedHashSet<String>();
        String value = entityGraph.getString("value");
        if (StringUtils.hasText((String)value)) {
            entityGraphNames.add(value);
        }
        entityGraphNames.add(queryMethod.getNamedQueryName());
        entityGraphNames.add(this.getFallbackEntityGraphName(information, queryMethod));
        return entityGraphNames;
    }

    private String getFallbackEntityGraphName(RepositoryInformation information, JpaQueryMethod queryMethod) {
        Class domainType = information.getDomainType();
        Entity entity = (Entity)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)domainType, Entity.class);
        String entityName = entity != null && StringUtils.hasText((String)entity.name()) ? entity.name() : domainType.getSimpleName();
        return entityName + "." + queryMethod.getName();
    }
}

