/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.provider;

import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.hibernate.query.spi.SqmQuery;
import org.hibernate.query.sql.spi.NamedNativeQueryMemento;
import org.hibernate.query.sqm.spi.NamedSqmQueryMemento;
import org.jspecify.annotations.Nullable;

public abstract class HibernateUtils {
    private HibernateUtils() {
    }

    @Nullable
    public static String getHibernateQuery(Object query) {
        try {
            if (query instanceof SqmQuery) {
                SqmQuery sqmQuery = (SqmQuery)query;
                String hql = sqmQuery.getQueryString();
                if (!hql.equals("<criteria>")) {
                    return hql;
                }
                return sqmQuery.getSqmStatement().toHqlString();
            }
            if (query instanceof NamedSqmQueryMemento) {
                NamedSqmQueryMemento sqmQuery = (NamedSqmQueryMemento)query;
                String hql = sqmQuery.getHqlString();
                if (!hql.equals("<criteria>")) {
                    return hql;
                }
                return sqmQuery.getSqmStatement().toHqlString();
            }
            if (query instanceof NamedNativeQueryMemento) {
                NamedNativeQueryMemento nativeQuery = (NamedNativeQueryMemento)query;
                return nativeQuery.getSqlString();
            }
        }
        catch (RuntimeException runtimeException) {}
        if (query instanceof Query) {
            Query hibernateQuery = (Query)query;
            return hibernateQuery.getQueryString();
        }
        throw new IllegalArgumentException("Don't know how to extract the query string from " + String.valueOf(query));
    }

    public static boolean isNativeQuery(Object query) {
        if (query instanceof SqmQuery) {
            return false;
        }
        if (query instanceof NativeQuery) {
            return true;
        }
        if (query instanceof NamedSqmQueryMemento) {
            return false;
        }
        return query instanceof NamedNativeQueryMemento;
    }
}

