/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.mapping;

import org.springframework.data.annotation.Version;
import org.springframework.data.jpa.mapping.JpaPersistentEntity;
import org.springframework.data.jpa.mapping.JpaPersistentProperty;
import org.springframework.data.jpa.provider.ProxyIdAccessor;
import org.springframework.data.jpa.util.JpaMetamodel;
import org.springframework.data.mapping.IdentifierAccessor;
import org.springframework.data.mapping.model.BasicPersistentEntity;
import org.springframework.data.mapping.model.IdPropertyIdentifierAccessor;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;

class JpaPersistentEntityImpl<T>
extends BasicPersistentEntity<T, JpaPersistentProperty>
implements JpaPersistentEntity<T> {
    private static final String INVALID_VERSION_ANNOTATION = "%s is annotated with " + Version.class.getName() + " but needs to use " + jakarta.persistence.Version.class.getName() + " to trigger optimistic locking correctly";
    private final ProxyIdAccessor proxyIdAccessor;
    private final JpaMetamodel metamodel;

    public JpaPersistentEntityImpl(TypeInformation<T> information, ProxyIdAccessor proxyIdAccessor, JpaMetamodel metamodel) {
        super(information, null);
        this.proxyIdAccessor = proxyIdAccessor;
        this.metamodel = metamodel;
    }

    protected JpaPersistentProperty returnPropertyIfBetterIdPropertyCandidateOrNull(JpaPersistentProperty property) {
        return property.isIdProperty() ? property : null;
    }

    public IdentifierAccessor getIdentifierAccessor(Object bean) {
        return new JpaProxyAwareIdentifierAccessor(this, bean, this.proxyIdAccessor);
    }

    public void verify() {
        super.verify();
        JpaPersistentProperty versionProperty = (JpaPersistentProperty)this.getVersionProperty();
        Assert.state((versionProperty == null || !versionProperty.isAnnotationPresent(Version.class) ? 1 : 0) != 0, () -> String.format(INVALID_VERSION_ANNOTATION, versionProperty));
    }

    JpaMetamodel getMetamodel() {
        return this.metamodel;
    }

    private static class JpaProxyAwareIdentifierAccessor
    extends IdPropertyIdentifierAccessor {
        private final Object bean;
        private final ProxyIdAccessor proxyIdAccessor;

        JpaProxyAwareIdentifierAccessor(JpaPersistentEntity<?> entity, Object bean, ProxyIdAccessor proxyIdAccessor) {
            super(entity, bean);
            Assert.notNull((Object)proxyIdAccessor, (String)"Proxy identifier accessor must not be null");
            this.proxyIdAccessor = proxyIdAccessor;
            this.bean = bean;
        }

        public Object getIdentifier() {
            return this.proxyIdAccessor.shouldUseAccessorFor(this.bean) ? this.proxyIdAccessor.getIdentifierFrom(this.bean) : super.getIdentifier();
        }
    }
}

