/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.data.jpa.repository.query.HqlBaseVisitor;
import org.springframework.data.jpa.repository.query.HqlParser;
import org.springframework.data.jpa.repository.query.HqlQueryRenderer;
import org.springframework.data.jpa.repository.query.ParsedQueryIntrospector;
import org.springframework.data.jpa.repository.query.QueryRenderer;
import org.springframework.data.jpa.repository.query.QueryToken;
import org.springframework.data.jpa.repository.query.QueryTokens;
import org.springframework.lang.Nullable;

class HqlQueryIntrospector
extends HqlBaseVisitor<Void>
implements ParsedQueryIntrospector {
    private final HqlQueryRenderer renderer = new HqlQueryRenderer();
    @Nullable
    private String primaryFromAlias = null;
    @Nullable
    private List<QueryToken> projection;
    private boolean projectionProcessed;
    private boolean hasConstructorExpression = false;

    HqlQueryIntrospector() {
    }

    @Override
    public String getAlias() {
        return this.primaryFromAlias;
    }

    @Override
    public List<QueryToken> getProjection() {
        return this.projection == null ? Collections.emptyList() : this.projection;
    }

    @Override
    public boolean hasConstructorExpression() {
        return this.hasConstructorExpression;
    }

    @Override
    public Void visitSelectClause(HqlParser.SelectClauseContext ctx) {
        if (!this.projectionProcessed) {
            this.projection = HqlQueryIntrospector.captureSelectItems(ctx.selectionList().selection(), this.renderer);
            this.projectionProcessed = true;
        }
        return (Void)super.visitSelectClause(ctx);
    }

    @Override
    public Void visitFromRoot(HqlParser.FromRootContext ctx) {
        if (this.primaryFromAlias == null && ctx.variable() != null && !HqlQueryRenderer.isSubquery(ctx)) {
            this.primaryFromAlias = HqlQueryIntrospector.capturePrimaryAlias(ctx.variable());
        }
        return (Void)super.visitFromRoot(ctx);
    }

    @Override
    public Void visitInstantiation(HqlParser.InstantiationContext ctx) {
        this.hasConstructorExpression = true;
        return (Void)super.visitInstantiation(ctx);
    }

    private static String capturePrimaryAlias(HqlParser.VariableContext ctx) {
        return (ctx.reservedWord() != null ? ctx.reservedWord() : ctx.identifier().reservedWord()).getText();
    }

    private static List<QueryToken> captureSelectItems(List<HqlParser.SelectionContext> selections, HqlQueryRenderer itemRenderer) {
        ArrayList<QueryToken> selectItemTokens = new ArrayList<QueryToken>(selections.size() * 2);
        for (HqlParser.SelectionContext selection : selections) {
            if (!selectItemTokens.isEmpty()) {
                selectItemTokens.add(QueryTokens.TOKEN_COMMA);
            }
            selectItemTokens.add(QueryTokens.token(QueryRenderer.from(itemRenderer.visitSelection(selection)).render()));
        }
        return selectItemTokens;
    }
}

