/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.List;
import java.util.function.Supplier;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.TerminalNode;

class JpaQueryParsingToken {
    public static final JpaQueryParsingToken TOKEN_COMMA = new JpaQueryParsingToken(",");
    public static final JpaQueryParsingToken TOKEN_DOT = new JpaQueryParsingToken(".", false);
    public static final JpaQueryParsingToken TOKEN_EQUALS = new JpaQueryParsingToken("=");
    public static final JpaQueryParsingToken TOKEN_OPEN_PAREN = new JpaQueryParsingToken("(", false);
    public static final JpaQueryParsingToken TOKEN_CLOSE_PAREN = new JpaQueryParsingToken(")");
    public static final JpaQueryParsingToken TOKEN_ORDER_BY = new JpaQueryParsingToken("order by");
    public static final JpaQueryParsingToken TOKEN_LOWER_FUNC = new JpaQueryParsingToken("lower(", false);
    public static final JpaQueryParsingToken TOKEN_SELECT_COUNT = new JpaQueryParsingToken("select count(", false);
    public static final JpaQueryParsingToken TOKEN_PERCENT = new JpaQueryParsingToken("%");
    public static final JpaQueryParsingToken TOKEN_COUNT_FUNC = new JpaQueryParsingToken("count(", false);
    public static final JpaQueryParsingToken TOKEN_DOUBLE_PIPE = new JpaQueryParsingToken("||");
    public static final JpaQueryParsingToken TOKEN_OPEN_SQUARE_BRACKET = new JpaQueryParsingToken("[", false);
    public static final JpaQueryParsingToken TOKEN_CLOSE_SQUARE_BRACKET = new JpaQueryParsingToken("]");
    public static final JpaQueryParsingToken TOKEN_COLON = new JpaQueryParsingToken(":", false);
    public static final JpaQueryParsingToken TOKEN_QUESTION_MARK = new JpaQueryParsingToken("?", false);
    public static final JpaQueryParsingToken TOKEN_OPEN_BRACE = new JpaQueryParsingToken("{", false);
    public static final JpaQueryParsingToken TOKEN_CLOSE_BRACE = new JpaQueryParsingToken("}");
    public static final JpaQueryParsingToken TOKEN_CLOSE_SQUARE_BRACKET_BRACE = new JpaQueryParsingToken("]}");
    public static final JpaQueryParsingToken TOKEN_CLOSE_PAREN_BRACE = new JpaQueryParsingToken(")}");
    public static final JpaQueryParsingToken TOKEN_DOUBLE_UNDERSCORE = new JpaQueryParsingToken("__");
    public static final JpaQueryParsingToken TOKEN_AS = new JpaQueryParsingToken("AS");
    public static final JpaQueryParsingToken TOKEN_DESC = new JpaQueryParsingToken("desc", false);
    public static final JpaQueryParsingToken TOKEN_ASC = new JpaQueryParsingToken("asc", false);
    public static final JpaQueryParsingToken TOKEN_WITH = new JpaQueryParsingToken("WITH");
    public static final JpaQueryParsingToken TOKEN_NOT = new JpaQueryParsingToken("NOT");
    public static final JpaQueryParsingToken TOKEN_MATERIALIZED = new JpaQueryParsingToken("materialized");
    private final Supplier<String> token;
    private final boolean space;

    JpaQueryParsingToken(Supplier<String> token, boolean space) {
        this.token = token;
        this.space = space;
    }

    JpaQueryParsingToken(String token, boolean space) {
        this(() -> token, space);
    }

    JpaQueryParsingToken(Supplier<String> token) {
        this(token, true);
    }

    JpaQueryParsingToken(String token) {
        this(() -> token, true);
    }

    JpaQueryParsingToken(TerminalNode node, boolean space) {
        this(node.getText(), space);
    }

    JpaQueryParsingToken(TerminalNode node) {
        this(node.getText());
    }

    JpaQueryParsingToken(Token token, boolean space) {
        this(token.getText(), space);
    }

    JpaQueryParsingToken(Token token) {
        this(token.getText(), true);
    }

    String getToken() {
        return this.token.get();
    }

    boolean getSpace() {
        return this.space;
    }

    boolean isA(JpaQueryParsingToken token) {
        return token.getToken().equalsIgnoreCase(this.getToken());
    }

    public String toString() {
        return this.getToken();
    }

    static void SPACE(List<JpaQueryParsingToken> tokens) {
        if (!tokens.isEmpty()) {
            int index = tokens.size() - 1;
            JpaQueryParsingToken lastTokenWithSpacing = new JpaQueryParsingToken(tokens.get((int)index).token);
            tokens.remove(index);
            tokens.add(lastTokenWithSpacing);
        }
    }

    static void NOSPACE(List<JpaQueryParsingToken> tokens) {
        if (!tokens.isEmpty()) {
            int index = tokens.size() - 1;
            JpaQueryParsingToken lastTokenWithNoSpacing = new JpaQueryParsingToken(tokens.get((int)index).token, false);
            tokens.remove(index);
            tokens.add(lastTokenWithNoSpacing);
        }
    }

    static void CLIP(List<JpaQueryParsingToken> tokens) {
        if (!tokens.isEmpty()) {
            tokens.remove(tokens.size() - 1);
        }
    }

    static String render(List<JpaQueryParsingToken> tokens) {
        StringBuilder results = new StringBuilder();
        tokens.forEach(token -> {
            results.append(token.getToken());
            if (token.getSpace()) {
                results.append(" ");
            }
        });
        return results.toString().trim();
    }
}

