/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.util;

import java.util.Optional;
import org.springframework.data.util.ProxyUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;

class HibernateProxyDetector
implements ProxyUtils.ProxyDetector {
    private static final Optional<Class<?>> HIBERNATE_PROXY = Optional.ofNullable(HibernateProxyDetector.loadHibernateProxyType());

    HibernateProxyDetector() {
    }

    public Class<?> getUserType(Class<?> type) {
        return HIBERNATE_PROXY.map(it -> it.isAssignableFrom(type) ? type.getSuperclass() : type).filter(it -> !Object.class.equals(it)).orElse(type);
    }

    @Nullable
    private static Class<?> loadHibernateProxyType() {
        try {
            return ClassUtils.forName((String)"org.hibernate.proxy.HibernateProxy", (ClassLoader)HibernateProxyDetector.class.getClassLoader());
        }
        catch (ClassNotFoundException o_O) {
            return null;
        }
    }
}

