/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.Query;
import javax.persistence.QueryHint;
import javax.persistence.Tuple;
import javax.persistence.TupleElement;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.jpa.provider.PersistenceProvider;
import org.springframework.data.jpa.repository.query.Jpa21Utils;
import org.springframework.data.jpa.repository.query.JpaQueryExecution;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.jpa.repository.query.ParameterBinder;
import org.springframework.data.jpa.repository.query.ParameterBinderFactory;
import org.springframework.data.jpa.util.JpaMetamodel;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.util.Lazy;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class AbstractJpaQuery
implements RepositoryQuery {
    private final JpaQueryMethod method;
    private final EntityManager em;
    private final JpaMetamodel metamodel;
    private final PersistenceProvider provider;
    Lazy<ParameterBinder> parameterBinder = new Lazy(this::createBinder);

    public AbstractJpaQuery(JpaQueryMethod method, EntityManager em) {
        Assert.notNull((Object)((Object)method), (String)"JpaQueryMethod must not be null!");
        Assert.notNull((Object)em, (String)"EntityManager must not be null!");
        this.method = method;
        this.em = em;
        this.metamodel = JpaMetamodel.of(em.getMetamodel());
        this.provider = PersistenceProvider.fromEntityManager(em);
    }

    public JpaQueryMethod getQueryMethod() {
        return this.method;
    }

    protected EntityManager getEntityManager() {
        return this.em;
    }

    protected JpaMetamodel getMetamodel() {
        return this.metamodel;
    }

    @Nullable
    public Object execute(Object[] parameters) {
        return this.doExecute(this.getExecution(), parameters);
    }

    @Nullable
    private Object doExecute(JpaQueryExecution execution, Object[] values) {
        Object result = execution.execute(this, values);
        ParametersParameterAccessor accessor = new ParametersParameterAccessor((Parameters)this.method.getParameters(), values);
        ResultProcessor withDynamicProjection = this.method.getResultProcessor().withDynamicProjection((ParameterAccessor)accessor);
        return withDynamicProjection.processResult(result, (Converter)new TupleConverter(withDynamicProjection.getReturnedType()));
    }

    protected JpaQueryExecution getExecution() {
        if (this.method.isStreamQuery()) {
            return new JpaQueryExecution.StreamExecution();
        }
        if (this.method.isProcedureQuery()) {
            return new JpaQueryExecution.ProcedureExecution();
        }
        if (this.method.isCollectionQuery()) {
            return new JpaQueryExecution.CollectionExecution();
        }
        if (this.method.isSliceQuery()) {
            return new JpaQueryExecution.SlicedExecution(this.method.getParameters());
        }
        if (this.method.isPageQuery()) {
            return new JpaQueryExecution.PagedExecution(this.method.getParameters());
        }
        if (this.method.isModifyingQuery()) {
            return new JpaQueryExecution.ModifyingExecution(this.method, this.em);
        }
        return new JpaQueryExecution.SingleEntityExecution();
    }

    protected <T extends Query> T applyHints(T query, JpaQueryMethod method) {
        for (QueryHint hint : method.getHints()) {
            this.applyQueryHint(query, hint);
        }
        return query;
    }

    protected <T extends Query> void applyQueryHint(T query, QueryHint hint) {
        Assert.notNull(query, (String)"Query must not be null!");
        Assert.notNull((Object)hint, (String)"QueryHint must not be null!");
        query.setHint(hint.name(), (Object)hint.value());
    }

    private Query applyLockMode(Query query, JpaQueryMethod method) {
        LockModeType lockModeType = method.getLockModeType();
        return lockModeType == null ? query : query.setLockMode(lockModeType);
    }

    protected ParameterBinder createBinder() {
        return ParameterBinderFactory.createBinder(this.getQueryMethod().getParameters());
    }

    protected Query createQuery(Object[] values) {
        return this.applyLockMode(this.applyEntityGraphConfiguration(this.applyHints(this.doCreateQuery(values), this.method), this.method), this.method);
    }

    private Query applyEntityGraphConfiguration(Query query, JpaQueryMethod method) {
        Assert.notNull((Object)query, (String)"Query must not be null!");
        Assert.notNull((Object)((Object)method), (String)"JpaQueryMethod must not be null!");
        Map<String, Object> hints = Jpa21Utils.tryGetFetchGraphHints(this.em, method.getEntityGraph(), this.getQueryMethod().getEntityInformation().getJavaType());
        for (Map.Entry<String, Object> hint : hints.entrySet()) {
            query.setHint(hint.getKey(), hint.getValue());
        }
        return query;
    }

    protected Query createCountQuery(Object[] values) {
        Query countQuery = this.doCreateCountQuery(values);
        return this.method.applyHintsToCountQuery() ? this.applyHints(countQuery, this.method) : countQuery;
    }

    protected Optional<Class<?>> getTypeToRead(ReturnedType returnedType) {
        if (PersistenceProvider.ECLIPSELINK.equals(this.provider)) {
            return Optional.empty();
        }
        return returnedType.isProjecting() && !this.getMetamodel().isJpaManaged(returnedType.getReturnedType()) ? Optional.of(Tuple.class) : Optional.empty();
    }

    protected abstract Query doCreateQuery(Object[] var1);

    protected abstract Query doCreateCountQuery(Object[] var1);

    static class TupleConverter
    implements Converter<Object, Object> {
        private final ReturnedType type;

        public TupleConverter(ReturnedType type) {
            Assert.notNull((Object)type, (String)"Returned type must not be null!");
            this.type = type;
        }

        public Object convert(Object source) {
            Object value;
            if (!(source instanceof Tuple)) {
                return source;
            }
            Tuple tuple = (Tuple)source;
            List elements = tuple.getElements();
            if (elements.size() == 1 && (this.type.isInstance(value = tuple.get((TupleElement)elements.get(0))) || value == null)) {
                return value;
            }
            return new TupleBackedMap(tuple);
        }

        private static class TupleBackedMap
        implements Map<String, Object> {
            private static final String UNMODIFIABLE_MESSAGE = "A TupleBackedMap cannot be modified.";
            private final Tuple tuple;

            TupleBackedMap(Tuple tuple) {
                this.tuple = tuple;
            }

            @Override
            public int size() {
                return this.tuple.getElements().size();
            }

            @Override
            public boolean isEmpty() {
                return this.tuple.getElements().isEmpty();
            }

            @Override
            public boolean containsKey(Object key) {
                try {
                    this.tuple.get((String)key);
                    return true;
                }
                catch (IllegalArgumentException e) {
                    return false;
                }
            }

            @Override
            public boolean containsValue(Object value) {
                return Arrays.asList(this.tuple.toArray()).contains(value);
            }

            @Override
            @Nullable
            public Object get(Object key) {
                if (!(key instanceof String)) {
                    return null;
                }
                try {
                    return this.tuple.get((String)key);
                }
                catch (IllegalArgumentException e) {
                    return null;
                }
            }

            @Override
            public Object put(String key, Object value) {
                throw new UnsupportedOperationException(UNMODIFIABLE_MESSAGE);
            }

            @Override
            public Object remove(Object key) {
                throw new UnsupportedOperationException(UNMODIFIABLE_MESSAGE);
            }

            @Override
            public void putAll(Map<? extends String, ?> m) {
                throw new UnsupportedOperationException(UNMODIFIABLE_MESSAGE);
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException(UNMODIFIABLE_MESSAGE);
            }

            @Override
            public Set<String> keySet() {
                return this.tuple.getElements().stream().map(TupleElement::getAlias).collect(Collectors.toSet());
            }

            @Override
            public Collection<Object> values() {
                return Arrays.asList(this.tuple.toArray());
            }

            @Override
            public Set<Map.Entry<String, Object>> entrySet() {
                return this.tuple.getElements().stream().map(e -> new AbstractMap.SimpleEntry<String, Object>(e.getAlias(), this.tuple.get(e))).collect(Collectors.toSet());
            }
        }
    }
}

