/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.Optional;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.Tuple;
import javax.persistence.TypedQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.provider.QueryExtractor;
import org.springframework.data.jpa.repository.query.AbstractJpaQuery;
import org.springframework.data.jpa.repository.query.DeclaredQuery;
import org.springframework.data.jpa.repository.query.JpaParameters;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.jpa.repository.query.ParameterBinder;
import org.springframework.data.jpa.repository.query.QueryParameterSetter;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.QueryCreationException;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.lang.Nullable;

final class NamedQuery
extends AbstractJpaQuery {
    private static final String CANNOT_EXTRACT_QUERY = "Your persistence provider does not support extracting the JPQL query from a named query thus you can't use Pageable inside your query method. Make sure you have a JpaDialect configured at your EntityManagerFactoryBean as this affects discovering the concrete persistence provider.";
    private static final Logger LOG = LoggerFactory.getLogger(NamedQuery.class);
    private final String queryName;
    private final String countQueryName;
    @Nullable
    private final String countProjection;
    private final QueryExtractor extractor;
    private final boolean namedCountQueryIsPresent;
    private final DeclaredQuery declaredQuery;

    private NamedQuery(JpaQueryMethod method, EntityManager em) {
        super(method, em);
        boolean cantExtractQuery;
        this.queryName = method.getNamedQueryName();
        this.countQueryName = method.getNamedCountQueryName();
        this.extractor = method.getQueryExtractor();
        this.countProjection = method.getCountQueryProjection();
        JpaParameters parameters = method.getParameters();
        if (parameters.hasSortParameter()) {
            throw new IllegalStateException(String.format("Finder method %s is backed by a NamedQuery and must not contain a sort parameter as we cannot modify the query! Use @Query instead!", new Object[]{method}));
        }
        this.namedCountQueryIsPresent = NamedQuery.hasNamedQuery(em, this.countQueryName);
        Query query = em.createNamedQuery(this.queryName);
        String queryString = this.extractor.extractQueryString(query);
        this.declaredQuery = DeclaredQuery.of(queryString);
        boolean weNeedToCreateCountQuery = !this.namedCountQueryIsPresent && method.getParameters().hasPageableParameter();
        boolean bl = cantExtractQuery = !this.extractor.canExtractQuery();
        if (weNeedToCreateCountQuery && cantExtractQuery) {
            throw QueryCreationException.create((QueryMethod)method, (String)CANNOT_EXTRACT_QUERY);
        }
        if (parameters.hasPageableParameter()) {
            LOG.warn("Finder method {} is backed by a NamedQuery but contains a Pageable parameter! Sorting delivered via this Pageable will not be applied!", (Object)method);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean hasNamedQuery(EntityManager em, String queryName) {
        try (EntityManager lookupEm = em.getEntityManagerFactory().createEntityManager();){
            lookupEm.createNamedQuery(queryName);
            boolean bl = true;
            return bl;
        }
    }

    @Nullable
    public static RepositoryQuery lookupFrom(JpaQueryMethod method, EntityManager em) {
        String queryName = method.getNamedQueryName();
        LOG.debug("Looking up named query {}", (Object)queryName);
        if (!NamedQuery.hasNamedQuery(em, queryName)) {
            return null;
        }
        try {
            NamedQuery query = new NamedQuery(method, em);
            LOG.debug("Found named query {}!", (Object)queryName);
            return query;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    protected Query doCreateQuery(Object[] values) {
        EntityManager em = this.getEntityManager();
        JpaQueryMethod queryMethod = this.getQueryMethod();
        ResultProcessor processor = queryMethod.getResultProcessor().withDynamicProjection((ParameterAccessor)new ParametersParameterAccessor((Parameters)queryMethod.getParameters(), values));
        Query query = this.getTypeToRead(processor.getReturnedType()).map(it -> em.createNamedQuery(this.queryName, it)).orElseGet(() -> em.createNamedQuery(this.queryName));
        return ((ParameterBinder)this.parameterBinder.get()).bindAndPrepare(query, values);
    }

    protected TypedQuery<Long> doCreateCountQuery(Object[] values) {
        TypedQuery countQuery;
        EntityManager em = this.getEntityManager();
        if (this.namedCountQueryIsPresent) {
            countQuery = em.createNamedQuery(this.countQueryName, Long.class);
        } else {
            String countQueryString = this.declaredQuery.deriveCountQuery(null, this.countProjection).getQueryString();
            countQuery = em.createQuery(countQueryString, Long.class);
        }
        return ((ParameterBinder)this.parameterBinder.get()).bind(countQuery, values, QueryParameterSetter.ErrorHandling.LENIENT);
    }

    @Override
    protected Optional<Class<?>> getTypeToRead(ReturnedType returnedType) {
        if (this.getQueryMethod().isNativeQuery()) {
            Class type = returnedType.getReturnedType();
            Class domainType = returnedType.getDomainType();
            if (domainType.isAssignableFrom(type)) {
                return Optional.of(type);
            }
            if (type.isAssignableFrom(domainType)) {
                return Optional.of(domainType);
            }
            return type.isInterface() ? Optional.of(Tuple.class) : Optional.empty();
        }
        return this.declaredQuery.hasConstructorExpression() ? Optional.empty() : super.getTypeToRead(returnedType);
    }
}

