/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.Date;
import java.util.Iterator;
import javax.persistence.Query;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.query.JpaParameters;
import org.springframework.data.jpa.repository.query.QueryUtils;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.util.Assert;

public class ParameterBinder {
    private final JpaParameters parameters;
    private final ParameterAccessor accessor;
    private final Object[] values;

    public ParameterBinder(JpaParameters parameters, Object[] values) {
        Assert.notNull((Object)((Object)parameters));
        Assert.notNull((Object)values);
        Assert.isTrue((parameters.getNumberOfParameters() == values.length ? 1 : 0) != 0, (String)"Invalid number of parameters given!");
        this.parameters = parameters;
        this.values = (Object[])values.clone();
        this.accessor = new ParametersParameterAccessor((Parameters)parameters, this.values);
    }

    ParameterBinder(JpaParameters parameters) {
        this(parameters, new Object[0]);
    }

    public Pageable getPageable() {
        return this.accessor.getPageable();
    }

    public Sort getSort() {
        return this.accessor.getSort();
    }

    public <T extends Query> T bind(T query) {
        int bindableParameterIndex = 0;
        int queryParameterPosition = 1;
        Iterator iterator = this.parameters.iterator();
        while (iterator.hasNext()) {
            JpaParameters.JpaParameter parameter = (JpaParameters.JpaParameter)((Object)iterator.next());
            if (!this.canBindParameter(parameter)) continue;
            Object value = this.accessor.getBindableValue(bindableParameterIndex);
            this.bind(query, parameter, value, queryParameterPosition++);
            ++bindableParameterIndex;
        }
        return query;
    }

    protected boolean canBindParameter(JpaParameters.JpaParameter parameter) {
        return parameter.isBindable();
    }

    protected void bind(Query query, JpaParameters.JpaParameter parameter, Object value, int position) {
        if (parameter.isTemporalParameter()) {
            if (this.hasNamedParameter(query) && parameter.isNamedParameter()) {
                query.setParameter(parameter.getName(), (Date)value, parameter.getTemporalType());
            } else {
                query.setParameter(position, (Date)value, parameter.getTemporalType());
            }
            return;
        }
        if (this.hasNamedParameter(query) && parameter.isNamedParameter()) {
            query.setParameter(parameter.getName(), value);
        } else {
            query.setParameter(position, value);
        }
    }

    public Query bindAndPrepare(Query query) {
        return this.bindAndPrepare(query, this.parameters);
    }

    boolean hasNamedParameter(Query query) {
        return QueryUtils.hasNamedParameter(query);
    }

    private Query bindAndPrepare(Query query, Parameters<?, ?> parameters) {
        Query result = this.bind(query);
        if (!parameters.hasPageableParameter() || this.getPageable() == null) {
            return result;
        }
        result.setFirstResult(this.getPageable().getOffset());
        result.setMaxResults(this.getPageable().getPageSize());
        return result;
    }

    JpaParameters getParameters() {
        return this.parameters;
    }

    protected Object[] getValues() {
        return this.values;
    }
}

