/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.repository.support;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.data.jdbc.core.JdbcAggregateOperations;
import org.springframework.data.jdbc.core.convert.QueryMappingConfiguration;
import org.springframework.data.jdbc.repository.support.DefaultRowMapperFactory;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;

public class BeanFactoryAwareRowMapperFactory
extends DefaultRowMapperFactory {
    private final BeanFactory beanFactory;

    public BeanFactoryAwareRowMapperFactory(BeanFactory beanFactory, JdbcAggregateOperations operations, QueryMappingConfiguration queryMappingConfiguration) {
        super(operations, queryMappingConfiguration);
        this.beanFactory = beanFactory;
    }

    @Override
    public RowMapper<Object> getRowMapper(String reference) {
        return (RowMapper)this.beanFactory.getBean(reference, RowMapper.class);
    }

    @Override
    public ResultSetExtractor<Object> getResultSetExtractor(String reference) {
        return (ResultSetExtractor)this.beanFactory.getBean(reference, ResultSetExtractor.class);
    }
}

