/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.repository.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.jdbc.core.convert.QueryMapper;
import org.springframework.data.jdbc.repository.query.ParametrizedQuery;
import org.springframework.data.jdbc.repository.query.SqlContext;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.relational.core.dialect.Dialect;
import org.springframework.data.relational.core.dialect.RenderContextFactory;
import org.springframework.data.relational.core.mapping.AggregatePath;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.query.Criteria;
import org.springframework.data.relational.core.query.CriteriaDefinition;
import org.springframework.data.relational.core.sql.Condition;
import org.springframework.data.relational.core.sql.Conditions;
import org.springframework.data.relational.core.sql.Delete;
import org.springframework.data.relational.core.sql.DeleteBuilder;
import org.springframework.data.relational.core.sql.Expression;
import org.springframework.data.relational.core.sql.Expressions;
import org.springframework.data.relational.core.sql.In;
import org.springframework.data.relational.core.sql.Select;
import org.springframework.data.relational.core.sql.SelectBuilder;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.data.relational.core.sql.StatementBuilder;
import org.springframework.data.relational.core.sql.Table;
import org.springframework.data.relational.core.sql.TableLike;
import org.springframework.data.relational.core.sql.render.RenderContext;
import org.springframework.data.relational.core.sql.render.SqlRenderer;
import org.springframework.data.relational.repository.query.RelationalEntityMetadata;
import org.springframework.data.relational.repository.query.RelationalParameterAccessor;
import org.springframework.data.relational.repository.query.RelationalQueryCreator;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.data.util.Predicates;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.util.Assert;

class JdbcDeleteQueryCreator
extends RelationalQueryCreator<List<ParametrizedQuery>> {
    private final RelationalMappingContext context;
    private final QueryMapper queryMapper;
    private final RelationalEntityMetadata<?> entityMetadata;
    private final RenderContextFactory renderContextFactory;

    JdbcDeleteQueryCreator(RelationalMappingContext context, PartTree tree, JdbcConverter converter, Dialect dialect, RelationalEntityMetadata<?> entityMetadata, RelationalParameterAccessor accessor) {
        super(tree, accessor);
        Assert.notNull((Object)converter, (String)"JdbcConverter must not be null");
        Assert.notNull((Object)dialect, (String)"Dialect must not be null");
        Assert.notNull(entityMetadata, (String)"Relational entity metadata must not be null");
        this.context = context;
        this.entityMetadata = entityMetadata;
        this.queryMapper = new QueryMapper(converter);
        this.renderContextFactory = new RenderContextFactory(dialect);
    }

    protected List<ParametrizedQuery> complete(@Nullable Criteria criteria, Sort sort) {
        RelationalPersistentEntity entity = this.entityMetadata.getTableEntity();
        Table table = Table.create((SqlIdentifier)this.entityMetadata.getTableName());
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        Condition condition = criteria == null ? null : this.queryMapper.getMappedObject(parameterSource, (CriteriaDefinition)criteria, table, entity);
        List idColumns = this.context.getAggregatePath(entity).getTableInfo().idColumnInfos().toColumnList(table);
        SelectBuilder.SelectFromAndJoin selectBuilder = StatementBuilder.select((Collection)idColumns).from((TableLike)table);
        Select select = condition == null ? selectBuilder.build() : selectBuilder.where(condition).build();
        ArrayList<Delete> deleteChain = new ArrayList<Delete>();
        this.deleteRelations(entity, select, deleteChain::add);
        DeleteBuilder.DeleteWhere deleteBuilder = StatementBuilder.delete((Table)table);
        Delete delete = condition == null ? deleteBuilder.build() : deleteBuilder.where(condition).build();
        deleteChain.add(delete);
        SqlRenderer renderer = SqlRenderer.create((RenderContext)this.renderContextFactory.createRenderContext());
        ArrayList<ParametrizedQuery> queries = new ArrayList<ParametrizedQuery>(deleteChain.size());
        for (Delete d : deleteChain) {
            queries.add(new ParametrizedQuery(renderer.render(d), (SqlParameterSource)parameterSource, criteria == null ? Criteria.empty() : criteria));
        }
        return queries;
    }

    private void deleteRelations(RelationalPersistentEntity<?> entity, Select parentSelect, Consumer<Delete> deleteConsumer) {
        for (PersistentPropertyPath path : this.context.findPersistentPropertyPaths(entity.getType(), Predicates.isTrue())) {
            AggregatePath aggregatePath = this.context.getAggregatePath(path);
            if (aggregatePath.isEmbedded() || !aggregatePath.isEntity()) continue;
            SqlContext sqlContext = new SqlContext();
            Table table = sqlContext.getUnaliasedTable(aggregatePath);
            List reverseColumns = aggregatePath.getTableInfo().backReferenceColumnInfos().toColumnList(table);
            Expression expression = Expressions.of((List)reverseColumns);
            In inCondition = Conditions.in((Expression)expression, (Select)parentSelect);
            List parentIdColumns = aggregatePath.getIdDefiningParentPath().getTableInfo().idColumnInfos().toColumnList(table);
            Select select = StatementBuilder.select((Collection)parentIdColumns).from((TableLike)table).where((Condition)inCondition).build();
            this.deleteRelations(aggregatePath.getRequiredLeafEntity(), select, deleteConsumer);
            deleteConsumer.accept(StatementBuilder.delete((Table)table).where((Condition)inCondition).build());
        }
    }
}

