/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.repository.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.domain.ManagedTypes;
import org.springframework.data.jdbc.core.convert.DataAccessStrategy;
import org.springframework.data.jdbc.core.convert.DataAccessStrategyFactory;
import org.springframework.data.jdbc.core.convert.DefaultJdbcTypeFactory;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.jdbc.core.convert.JdbcCustomConversions;
import org.springframework.data.jdbc.core.convert.MappingJdbcConverter;
import org.springframework.data.jdbc.core.convert.QueryMappingConfiguration;
import org.springframework.data.jdbc.core.convert.RelationResolver;
import org.springframework.data.jdbc.core.dialect.JdbcArrayColumns;
import org.springframework.data.jdbc.core.dialect.JdbcDialect;
import org.springframework.data.jdbc.core.mapping.JdbcMappingContext;
import org.springframework.data.jdbc.core.mapping.JdbcSimpleTypes;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.relational.RelationalManagedTypes;
import org.springframework.data.relational.core.dialect.Dialect;
import org.springframework.data.relational.core.mapping.DefaultNamingStrategy;
import org.springframework.data.relational.core.mapping.NamingStrategy;
import org.springframework.data.relational.core.mapping.Table;
import org.springframework.data.util.TypeScanner;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.util.StringUtils;

public final class JdbcConfiguration {
    private JdbcConfiguration() {
    }

    public static JdbcCustomConversions createCustomConversions(JdbcDialect dialect, List<?> userConverters) {
        SimpleTypeHolder simpleTypeHolder = new SimpleTypeHolder(dialect.simpleTypes(), JdbcSimpleTypes.HOLDER);
        return new JdbcCustomConversions(CustomConversions.StoreConversions.of((SimpleTypeHolder)simpleTypeHolder, JdbcConfiguration.storeConverters(dialect)), userConverters);
    }

    private static List<Object> storeConverters(Dialect dialect) {
        ArrayList<Object> converters = new ArrayList<Object>();
        converters.addAll(dialect.getConverters());
        converters.addAll(JdbcCustomConversions.storeConverters());
        return converters;
    }

    public static JdbcMappingContext createMappingContext(RelationalManagedTypes jdbcManagedTypes, JdbcCustomConversions customConversions, @Nullable NamingStrategy namingStrategy) {
        JdbcMappingContext mappingContext = JdbcMappingContext.forQuotedIdentifiers(namingStrategy != null ? namingStrategy : DefaultNamingStrategy.INSTANCE);
        mappingContext.setSimpleTypeHolder(customConversions.getSimpleTypeHolder());
        mappingContext.setManagedTypes((ManagedTypes)jdbcManagedTypes);
        return mappingContext;
    }

    public static JdbcConverter createConverter(JdbcMappingContext mappingContext, NamedParameterJdbcOperations operations, RelationResolver relationResolver, JdbcCustomConversions conversions, JdbcDialect dialect) {
        JdbcArrayColumns arrayColumns = JdbcDialect.getArraySupport(dialect);
        DefaultJdbcTypeFactory jdbcTypeFactory = new DefaultJdbcTypeFactory(operations.getJdbcOperations(), arrayColumns);
        MappingJdbcConverter mappingJdbcConverter = new MappingJdbcConverter(mappingContext, relationResolver, conversions, jdbcTypeFactory);
        JdbcOperations jdbcOperations = operations.getJdbcOperations();
        if (jdbcOperations instanceof JdbcTemplate) {
            JdbcTemplate jdbcTemplate = (JdbcTemplate)jdbcOperations;
            mappingJdbcConverter.setExceptionTranslator(jdbcTemplate.getExceptionTranslator());
        }
        return mappingJdbcConverter;
    }

    public static DataAccessStrategy createDataAccessStrategy(NamedParameterJdbcOperations operations, JdbcConverter jdbcConverter, @Nullable QueryMappingConfiguration mappingConfiguration, JdbcDialect dialect) {
        return new DataAccessStrategyFactory(jdbcConverter, operations, dialect, mappingConfiguration == null ? QueryMappingConfiguration.EMPTY : mappingConfiguration).create();
    }

    public static Set<Class<?>> scanForEntities(String basePackage) {
        if (!StringUtils.hasText((String)basePackage)) {
            return Collections.emptySet();
        }
        return TypeScanner.typeScanner((ClassLoader)JdbcConfiguration.class.getClassLoader()).forTypesAnnotatedWith(new Class[]{Table.class}).scanPackages(new String[]{basePackage}).collectAsSet();
    }
}

