/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.repository.aot;

import java.util.List;
import org.springframework.data.jdbc.repository.aot.AotQuery;
import org.springframework.data.jdbc.repository.query.ParameterBinding;

abstract class StringAotQuery
extends AotQuery {
    StringAotQuery(List<ParameterBinding> parameterBindings) {
        super(parameterBindings);
    }

    static StringAotQuery of(String query, List<ParameterBinding> parameterBindings) {
        return new DeclaredAotQuery(query, parameterBindings);
    }

    static StringAotQuery named(String queryName, String query, List<ParameterBinding> parameterBindings) {
        return new NamedStringAotQuery(queryName, query, parameterBindings);
    }

    public abstract String getQueryString();

    public String toString() {
        return this.getQueryString();
    }

    private static class DeclaredAotQuery
    extends StringAotQuery {
        private final String query;

        DeclaredAotQuery(String query, List<ParameterBinding> parameterBindings) {
            super(parameterBindings);
            this.query = query;
        }

        @Override
        public String getQueryString() {
            return this.query;
        }
    }

    static class NamedStringAotQuery
    extends DeclaredAotQuery {
        private final String queryName;

        NamedStringAotQuery(String queryName, String query, List<ParameterBinding> parameterBindings) {
            super(query, parameterBindings);
            this.queryName = queryName;
        }

        public String getQueryName() {
            return this.queryName;
        }
    }
}

