/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.dialect;

import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import microsoft.sql.DateTimeOffset;
import org.jspecify.annotations.Nullable;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.jdbc.core.dialect.JdbcDialect;
import org.springframework.data.relational.core.dialect.SqlServerDialect;
import org.springframework.data.util.ClassUtils;

public class JdbcSqlServerDialect
extends SqlServerDialect
implements JdbcDialect {
    public static final JdbcSqlServerDialect INSTANCE = new JdbcSqlServerDialect();
    private static final @Nullable Class<?> DATE_TIME_OFFSET_CLASS = ClassUtils.loadIfPresent((String)"microsoft.sql.DateTimeOffset", (ClassLoader)JdbcSqlServerDialect.class.getClassLoader());
    private static final Set<Class<?>> SIMPLE_TYPES;
    private static final List<Object> CONVERTERS;

    public Set<Class<?>> simpleTypes() {
        return SIMPLE_TYPES;
    }

    public Collection<Object> getConverters() {
        ArrayList<Object> converters = new ArrayList<Object>(super.getConverters());
        converters.addAll(CONVERTERS);
        return converters;
    }

    static {
        if (DATE_TIME_OFFSET_CLASS != null) {
            SIMPLE_TYPES = Set.of(DATE_TIME_OFFSET_CLASS);
            CONVERTERS = List.of(DateTimeOffsetToOffsetDateTimeConverter.INSTANCE, DateTimeOffsetToInstantConverter.INSTANCE);
        } else {
            SIMPLE_TYPES = Set.of();
            CONVERTERS = List.of();
        }
    }

    @ReadingConverter
    static enum DateTimeOffsetToOffsetDateTimeConverter implements Converter<DateTimeOffset, OffsetDateTime>
    {
        INSTANCE;


        public OffsetDateTime convert(DateTimeOffset source) {
            return source.getOffsetDateTime();
        }
    }

    @ReadingConverter
    static enum DateTimeOffsetToInstantConverter implements Converter<DateTimeOffset, Instant>
    {
        INSTANCE;


        public Instant convert(DateTimeOffset source) {
            return source.getOffsetDateTime().toInstant();
        }
    }
}

