/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.mapping.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.data.annotation.Id;
import org.springframework.data.jdbc.core.mapping.schema.Column;
import org.springframework.data.jdbc.core.mapping.schema.DefaultSqlTypeMapping;
import org.springframework.data.jdbc.core.mapping.schema.ForeignKey;
import org.springframework.data.jdbc.core.mapping.schema.SqlTypeMapping;
import org.springframework.data.jdbc.core.mapping.schema.Table;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.relational.core.mapping.MappedCollection;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

record Tables(List<Table> tables) {
    public static Tables from(RelationalMappingContext context) {
        return Tables.from(context.getPersistentEntities().stream(), new DefaultSqlTypeMapping(), null, context);
    }

    public static Tables from(Stream<? extends RelationalPersistentEntity<?>> persistentEntities, SqlTypeMapping sqlTypeMapping, @Nullable String defaultSchema, MappingContext<? extends RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> context) {
        ArrayList<ForeignKeyMetadata> foreignKeyMetadataList = new ArrayList<ForeignKeyMetadata>();
        List<Table> tables = persistentEntities.filter(it -> it.isAnnotationPresent(org.springframework.data.relational.core.mapping.Table.class)).map(entity -> {
            Table table = new Table(defaultSchema, entity.getTableName().getReference());
            LinkedHashSet identifierColumns = new LinkedHashSet();
            entity.getPersistentProperties(Id.class).forEach(identifierColumns::add);
            for (RelationalPersistentProperty property : entity) {
                if (property.isEntity() && !property.isEmbedded()) {
                    foreignKeyMetadataList.add(Tables.createForeignKeyMetadata(entity, property, context, sqlTypeMapping));
                    continue;
                }
                Column column = new Column(property.getColumnName().getReference(), sqlTypeMapping.getColumnType(property), sqlTypeMapping.isNullable(property), identifierColumns.contains(property));
                table.columns().add(column);
            }
            return table;
        }).collect(Collectors.toList());
        Tables.applyForeignKeyMetadata(tables, foreignKeyMetadataList);
        return new Tables(tables);
    }

    public static Tables empty() {
        return new Tables(Collections.emptyList());
    }

    private static void applyForeignKeyMetadata(List<Table> tables, List<ForeignKeyMetadata> foreignKeyMetadataList) {
        foreignKeyMetadataList.forEach(foreignKeyMetadata -> {
            Table table = tables.stream().filter(t -> t.name().equals(foreignKeyMetadata.tableName)).findAny().orElseThrow();
            List<Column> parentIdColumns = Tables.collectParentIdentityColumns(foreignKeyMetadata, foreignKeyMetadataList, tables);
            List<String> parentIdColumnNames = parentIdColumns.stream().map(Column::name).toList();
            String foreignKeyName = Tables.getForeignKeyName(foreignKeyMetadata.parentTableName, parentIdColumnNames);
            if (parentIdColumnNames.size() == 1) {
                Tables.addIfAbsent(table.columns(), new Column(foreignKeyMetadata.referencingColumnName(), parentIdColumns.get(0).type(), false, table.getIdColumns().isEmpty()));
                if (foreignKeyMetadata.keyColumnName() != null) {
                    Tables.addIfAbsent(table.columns(), new Column(foreignKeyMetadata.keyColumnName(), foreignKeyMetadata.keyColumnType(), false, true));
                }
                Tables.addIfAbsent(table.foreignKeys(), new ForeignKey(foreignKeyName, foreignKeyMetadata.tableName(), List.of(foreignKeyMetadata.referencingColumnName()), foreignKeyMetadata.parentTableName(), parentIdColumnNames));
            } else {
                Tables.addIfAbsent(table.columns(), parentIdColumns.toArray(new Column[0]));
                Tables.addIfAbsent(table.columns(), new Column(foreignKeyMetadata.keyColumnName(), foreignKeyMetadata.keyColumnType(), false, true));
                Tables.addIfAbsent(table.foreignKeys(), new ForeignKey(foreignKeyName, foreignKeyMetadata.tableName(), parentIdColumnNames, foreignKeyMetadata.parentTableName(), parentIdColumnNames));
            }
        });
    }

    private static <E> void addIfAbsent(List<E> list, E ... elements) {
        for (E element : elements) {
            if (list.contains(element)) continue;
            list.add(element);
        }
    }

    private static List<Column> collectParentIdentityColumns(ForeignKeyMetadata child, List<ForeignKeyMetadata> foreignKeyMetadataList, List<Table> tables) {
        return Tables.collectParentIdentityColumns(child, foreignKeyMetadataList, tables, new HashSet<String>());
    }

    private static List<Column> collectParentIdentityColumns(ForeignKeyMetadata child, List<ForeignKeyMetadata> foreignKeyMetadataList, List<Table> tables, Set<String> excludeTables) {
        excludeTables.add(child.tableName());
        Table parentTable = Tables.findTableByName(tables, child.parentTableName());
        ForeignKeyMetadata parentMetadata = Tables.findMetadataByTableName(foreignKeyMetadataList, child.parentTableName(), excludeTables);
        List<Column> parentIdColumns = parentTable.getIdColumns();
        if (!parentIdColumns.isEmpty()) {
            return new ArrayList<Column>(parentIdColumns);
        }
        Assert.state((parentMetadata != null ? 1 : 0) != 0, (String)"parentMetadata must not be null at this stage");
        List<Column> parentParentIdColumns = Tables.collectParentIdentityColumns(parentMetadata, foreignKeyMetadataList, tables);
        if (parentParentIdColumns.size() == 1) {
            Column parentParentIdColumn = parentParentIdColumns.get(0);
            Column withChangedName = new Column(parentMetadata.referencingColumnName, parentParentIdColumn.type(), false, true);
            parentParentIdColumns = new LinkedList<Column>(List.of(withChangedName));
        }
        if (parentMetadata.keyColumnName() != null) {
            parentParentIdColumns.add(new Column(parentMetadata.keyColumnName(), parentMetadata.keyColumnType(), false, true));
        }
        return parentParentIdColumns;
    }

    @Nullable
    private static Table findTableByName(List<Table> tables, String tableName) {
        return tables.stream().filter(table -> table.name().equals(tableName)).findAny().orElse(null);
    }

    @Nullable
    private static ForeignKeyMetadata findMetadataByTableName(List<ForeignKeyMetadata> metadata, String tableName, Set<String> excludeTables) {
        return metadata.stream().filter(m -> m.tableName().equals(tableName) && !excludeTables.contains(m.parentTableName())).findAny().orElse(null);
    }

    private static ForeignKeyMetadata createForeignKeyMetadata(RelationalPersistentEntity<?> entity, RelationalPersistentProperty property, MappingContext<? extends RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> context, SqlTypeMapping sqlTypeMapping) {
        RelationalPersistentEntity childEntity = (RelationalPersistentEntity)context.getRequiredPersistentEntity(property.getActualType());
        String referencedKeyColumnType = null;
        if (property.isAnnotationPresent(MappedCollection.class)) {
            if (property.getType() == List.class) {
                referencedKeyColumnType = sqlTypeMapping.getColumnType(Integer.class);
            } else if (property.getType() == Map.class) {
                referencedKeyColumnType = sqlTypeMapping.getColumnType(property.getComponentType());
            }
        }
        return new ForeignKeyMetadata(childEntity.getTableName().getReference(), property.getReverseColumnName(entity).getReference(), Optional.ofNullable(property.getKeyColumn()).map(SqlIdentifier::getReference).orElse(null), referencedKeyColumnType, entity.getTableName().getReference());
    }

    private static String getForeignKeyName(String referencedTableName, List<String> referencedColumnNames) {
        return String.format("%s_%s_fk", referencedTableName, String.join((CharSequence)"_", referencedColumnNames));
    }

    private record ForeignKeyMetadata(String tableName, String referencingColumnName, @Nullable String keyColumnName, @Nullable String keyColumnType, String parentTableName) {
    }
}

