/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.convert;

import org.springframework.data.jdbc.core.convert.BatchInsertStrategy;
import org.springframework.data.jdbc.core.convert.IdGeneratingBatchInsertStrategy;
import org.springframework.data.jdbc.core.convert.IdGeneratingInsertStrategy;
import org.springframework.data.jdbc.core.convert.InsertStrategy;
import org.springframework.data.relational.core.conversion.IdValueSource;
import org.springframework.data.relational.core.dialect.Dialect;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.lang.Nullable;

public class InsertStrategyFactory {
    private final NamedParameterJdbcOperations jdbcOperations;
    private final Dialect dialect;

    public InsertStrategyFactory(NamedParameterJdbcOperations jdbcOperations, Dialect dialect) {
        this.jdbcOperations = jdbcOperations;
        this.dialect = dialect;
    }

    InsertStrategy insertStrategy(IdValueSource idValueSource, @Nullable SqlIdentifier idColumn) {
        if (IdValueSource.GENERATED.equals((Object)idValueSource)) {
            return new IdGeneratingInsertStrategy(this.dialect, this.jdbcOperations, idColumn);
        }
        return new DefaultInsertStrategy(this.jdbcOperations);
    }

    BatchInsertStrategy batchInsertStrategy(IdValueSource idValueSource, @Nullable SqlIdentifier idColumn) {
        if (IdValueSource.GENERATED.equals((Object)idValueSource)) {
            return new IdGeneratingBatchInsertStrategy(new IdGeneratingInsertStrategy(this.dialect, this.jdbcOperations, idColumn), this.dialect, this.jdbcOperations, idColumn);
        }
        return new DefaultBatchInsertStrategy(this.jdbcOperations);
    }

    private static class DefaultInsertStrategy
    implements InsertStrategy {
        private final NamedParameterJdbcOperations jdbcOperations;

        DefaultInsertStrategy(NamedParameterJdbcOperations jdbcOperations) {
            this.jdbcOperations = jdbcOperations;
        }

        @Override
        public Object execute(String sql, SqlParameterSource sqlParameterSource) {
            this.jdbcOperations.update(sql, sqlParameterSource);
            return null;
        }
    }

    private static class DefaultBatchInsertStrategy
    implements BatchInsertStrategy {
        private final NamedParameterJdbcOperations jdbcOperations;

        DefaultBatchInsertStrategy(NamedParameterJdbcOperations jdbcOperations) {
            this.jdbcOperations = jdbcOperations;
        }

        @Override
        public Object[] execute(String sql, SqlParameterSource[] sqlParameterSources) {
            this.jdbcOperations.batchUpdate(sql, sqlParameterSources);
            return new Object[sqlParameterSources.length];
        }
    }
}

