/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.convert;

import java.util.HashMap;
import java.util.Map;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalConverter;
import org.springframework.core.convert.converter.Converter;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class IterableOfEntryToMapConverter
implements ConditionalConverter,
Converter<Iterable<?>, Map<?, ?>> {
    IterableOfEntryToMapConverter() {
    }

    @Nullable
    public Map<?, ?> convert(Iterable<?> source) {
        HashMap result = new HashMap();
        source.forEach(element -> {
            if (!(element instanceof Map.Entry)) {
                throw new IllegalArgumentException(String.format("Cannot convert %s to Map.Entry", element.getClass()));
            }
            Map.Entry entry = (Map.Entry)element;
            result.put(entry.getKey(), entry.getValue());
        });
        return result;
    }

    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        Assert.notNull((Object)sourceType, (String)"Source type must not be null");
        Assert.notNull((Object)targetType, (String)"Target type must not be null");
        if (!sourceType.isAssignableTo(TypeDescriptor.valueOf(Iterable.class))) {
            return false;
        }
        TypeDescriptor elementDescriptor = sourceType.getElementTypeDescriptor();
        return elementDescriptor == null || elementDescriptor.isAssignableTo(TypeDescriptor.valueOf(Map.Entry.class));
    }
}

