/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.convert;

import java.sql.Array;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.data.jdbc.core.convert.PathToColumnMapping;
import org.springframework.data.jdbc.core.convert.RowDocumentExtractorSupport;
import org.springframework.data.relational.core.mapping.AggregatePath;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.domain.RowDocument;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.LinkedCaseInsensitiveMap;

class RowDocumentResultSetExtractor {
    private final RelationalMappingContext context;
    private final PathToColumnMapping propertyToColumn;

    RowDocumentResultSetExtractor(RelationalMappingContext context, PathToColumnMapping propertyToColumn) {
        this.context = context;
        this.propertyToColumn = propertyToColumn;
    }

    static RowDocument toRowDocument(ResultSet resultSet) throws SQLException {
        ResultSetMetaData md = resultSet.getMetaData();
        int columnCount = md.getColumnCount();
        RowDocument document = new RowDocument(columnCount);
        for (int i = 0; i < columnCount; ++i) {
            Object object;
            Object rsv = JdbcUtils.getResultSetValue((ResultSet)resultSet, (int)(i + 1));
            String columnName = md.getColumnLabel(i + 1);
            if (rsv instanceof Array) {
                Array a = (Array)rsv;
                object = a.getArray();
            } else {
                object = rsv;
            }
            document.put(columnName, object);
        }
        return document;
    }

    public RowDocument extractNextDocument(Class<?> entity, ResultSet resultSet) throws SQLException {
        return this.extractNextDocument((RelationalPersistentEntity)this.context.getRequiredPersistentEntity(entity), resultSet);
    }

    public RowDocument extractNextDocument(RelationalPersistentEntity<?> entity, ResultSet resultSet) throws SQLException {
        Iterator<RowDocument> iterator = this.iterate(entity, resultSet);
        if (!iterator.hasNext()) {
            throw new IllegalStateException("ResultSet is fully consumed");
        }
        return iterator.next();
    }

    public Iterator<RowDocument> iterate(RelationalPersistentEntity<?> entity, ResultSet rs) throws SQLException {
        return new RowDocumentIterator(entity, rs);
    }

    private class RowDocumentIterator
    implements Iterator<RowDocument> {
        private final ResultSet resultSet;
        private final AggregatePath rootPath;
        private final RelationalPersistentEntity<?> rootEntity;
        private final Integer identifierIndex;
        private final RowDocumentExtractorSupport.AggregateContext<ResultSet> aggregateContext;
        private boolean hasNext;

        RowDocumentIterator(RelationalPersistentEntity<?> entity, ResultSet resultSet) {
            ResultSetAdapter adapter = ResultSetAdapter.INSTANCE;
            this.rootPath = RowDocumentResultSetExtractor.this.context.getAggregatePath(entity);
            this.rootEntity = entity;
            String idColumn = RowDocumentResultSetExtractor.this.propertyToColumn.column(this.rootPath.append((RelationalPersistentProperty)entity.getRequiredIdProperty()));
            Map<String, Integer> columns = adapter.getColumnMap(resultSet);
            this.aggregateContext = new RowDocumentExtractorSupport.AggregateContext<ResultSet>(adapter, RowDocumentResultSetExtractor.this.context, RowDocumentResultSetExtractor.this.propertyToColumn, columns);
            this.resultSet = resultSet;
            this.identifierIndex = columns.get(idColumn);
            this.hasNext = RowDocumentIterator.hasRow(resultSet);
        }

        private static boolean hasRow(ResultSet resultSet) {
            try {
                if (resultSet.isBeforeFirst()) {
                    return resultSet.next();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                if (resultSet.isAfterLast()) {
                    return false;
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                resultSet.getObject(1);
                return true;
            }
            catch (SQLException sQLException) {
                try {
                    return resultSet.next();
                }
                catch (SQLException e) {
                    return false;
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        @Nullable
        public RowDocument next() {
            RowDocumentExtractorSupport.RowDocumentSink<ResultSet> reader = new RowDocumentExtractorSupport.RowDocumentSink<ResultSet>(this.aggregateContext, this.rootEntity, this.rootPath);
            Object key = ResultSetAdapter.INSTANCE.getObject(this.resultSet, (int)this.identifierIndex);
            try {
                Object nextKey;
                while ((nextKey = ResultSetAdapter.INSTANCE.getObject(this.resultSet, (int)this.identifierIndex)) == null || nextKey.equals(key)) {
                    reader.accept(this.resultSet);
                    this.hasNext = this.resultSet.next();
                    if (this.hasNext) continue;
                    break;
                }
            }
            catch (SQLException e) {
                throw new DataRetrievalFailureException("Cannot advance ResultSet", (Throwable)e);
            }
            return reader.getResult();
        }
    }

    static enum ResultSetAdapter implements RowDocumentExtractorSupport.TabularResultAdapter<ResultSet>
    {
        INSTANCE;


        @Override
        public Object getObject(ResultSet row, int index) {
            try {
                Object resultSetValue = JdbcUtils.getResultSetValue((ResultSet)row, (int)index);
                if (resultSetValue instanceof Array) {
                    Array a = (Array)resultSetValue;
                    return a.getArray();
                }
                return resultSetValue;
            }
            catch (SQLException e) {
                throw new DataRetrievalFailureException("Cannot retrieve column " + index + " from ResultSet", (Throwable)e);
            }
        }

        @Override
        public Map<String, Integer> getColumnMap(ResultSet result) {
            try {
                ResultSetMetaData metaData = result.getMetaData();
                LinkedCaseInsensitiveMap columns = new LinkedCaseInsensitiveMap(metaData.getColumnCount());
                for (int i = 0; i < metaData.getColumnCount(); ++i) {
                    columns.put(metaData.getColumnLabel(i + 1), i + 1);
                }
                return columns;
            }
            catch (SQLException e) {
                throw new DataRetrievalFailureException("Cannot retrieve ColumnMap from ResultSet", (Throwable)e);
            }
        }
    }
}

