/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.repository.config;

import java.lang.annotation.Annotation;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.data.auditing.IsNewAwareAuditingHandler;
import org.springframework.data.auditing.config.AuditingBeanDefinitionRegistrarSupport;
import org.springframework.data.auditing.config.AuditingConfiguration;
import org.springframework.data.config.ParsingUtils;
import org.springframework.data.jdbc.repository.config.EnableJdbcAuditing;
import org.springframework.data.relational.auditing.RelationalAuditingCallback;
import org.springframework.util.Assert;

class JdbcAuditingRegistrar
extends AuditingBeanDefinitionRegistrarSupport {
    private static final String AUDITING_HANDLER_BEAN_NAME = "jdbcAuditingHandler";

    JdbcAuditingRegistrar() {
    }

    protected Class<? extends Annotation> getAnnotation() {
        return EnableJdbcAuditing.class;
    }

    protected String getAuditingHandlerBeanName() {
        return AUDITING_HANDLER_BEAN_NAME;
    }

    protected void postProcess(BeanDefinitionBuilder builder, AuditingConfiguration configuration, BeanDefinitionRegistry registry) {
        builder.setFactoryMethod("from").addConstructorArgReference("jdbcMappingContext");
    }

    protected BeanDefinitionBuilder getAuditHandlerBeanDefinitionBuilder(AuditingConfiguration configuration) {
        Assert.notNull((Object)configuration, (String)"AuditingConfiguration must not be null");
        return this.configureDefaultAuditHandlerAttributes(configuration, BeanDefinitionBuilder.rootBeanDefinition(IsNewAwareAuditingHandler.class));
    }

    protected void registerAuditListenerBeanDefinition(BeanDefinition auditingHandlerDefinition, BeanDefinitionRegistry registry) {
        Assert.notNull((Object)auditingHandlerDefinition, (String)"BeanDefinition must not be null");
        Assert.notNull((Object)registry, (String)"BeanDefinitionRegistry must not be null");
        BeanDefinitionBuilder listenerBeanDefinitionBuilder = BeanDefinitionBuilder.rootBeanDefinition(RelationalAuditingCallback.class);
        listenerBeanDefinitionBuilder.addConstructorArgValue((Object)ParsingUtils.getObjectFactoryBeanDefinition((String)AUDITING_HANDLER_BEAN_NAME, (Object)registry));
        this.registerInfrastructureBeanWithId(listenerBeanDefinitionBuilder.getBeanDefinition(), RelationalAuditingCallback.class.getName(), registry);
    }
}

