/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.repository.support;

import java.util.Optional;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.jdbc.core.JdbcAggregateTemplate;
import org.springframework.data.jdbc.core.convert.DataAccessStrategy;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.jdbc.repository.QueryMappingConfiguration;
import org.springframework.data.jdbc.repository.support.JdbcQueryLookupStrategy;
import org.springframework.data.jdbc.repository.support.SimpleJdbcRepository;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.callback.EntityCallbacks;
import org.springframework.data.relational.core.dialect.Dialect;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.PersistentEntityInformation;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class JdbcRepositoryFactory
extends RepositoryFactorySupport {
    private final RelationalMappingContext context;
    private final JdbcConverter converter;
    private final ApplicationEventPublisher publisher;
    private final DataAccessStrategy accessStrategy;
    private final NamedParameterJdbcOperations operations;
    private final Dialect dialect;
    @Nullable
    private BeanFactory beanFactory;
    private QueryMappingConfiguration queryMappingConfiguration = QueryMappingConfiguration.EMPTY;
    private EntityCallbacks entityCallbacks;

    public JdbcRepositoryFactory(DataAccessStrategy dataAccessStrategy, RelationalMappingContext context, JdbcConverter converter, Dialect dialect, ApplicationEventPublisher publisher, NamedParameterJdbcOperations operations) {
        Assert.notNull((Object)dataAccessStrategy, (String)"DataAccessStrategy must not be null!");
        Assert.notNull((Object)context, (String)"RelationalMappingContext must not be null!");
        Assert.notNull((Object)converter, (String)"RelationalConverter must not be null!");
        Assert.notNull((Object)dialect, (String)"Dialect must not be null!");
        Assert.notNull((Object)publisher, (String)"ApplicationEventPublisher must not be null!");
        this.publisher = publisher;
        this.context = context;
        this.converter = converter;
        this.dialect = dialect;
        this.accessStrategy = dataAccessStrategy;
        this.operations = operations;
    }

    public void setQueryMappingConfiguration(QueryMappingConfiguration queryMappingConfiguration) {
        Assert.notNull((Object)queryMappingConfiguration, (String)"QueryMappingConfiguration must not be null!");
        this.queryMappingConfiguration = queryMappingConfiguration;
    }

    public <T, ID> EntityInformation<T, ID> getEntityInformation(Class<T> aClass) {
        RelationalPersistentEntity entity = (RelationalPersistentEntity)this.context.getRequiredPersistentEntity(aClass);
        return new PersistentEntityInformation((PersistentEntity)entity);
    }

    protected Object getTargetRepository(RepositoryInformation repositoryInformation) {
        JdbcAggregateTemplate template = new JdbcAggregateTemplate(this.publisher, this.context, this.converter, this.accessStrategy);
        if (this.entityCallbacks != null) {
            template.setEntityCallbacks(this.entityCallbacks);
        }
        RelationalPersistentEntity persistentEntity = (RelationalPersistentEntity)this.context.getRequiredPersistentEntity(repositoryInformation.getDomainType());
        return this.getTargetRepositoryViaReflection(repositoryInformation.getRepositoryBaseClass(), new Object[]{template, persistentEntity});
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata repositoryMetadata) {
        return SimpleJdbcRepository.class;
    }

    protected Optional<QueryLookupStrategy> getQueryLookupStrategy(@Nullable QueryLookupStrategy.Key key, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        return Optional.of(JdbcQueryLookupStrategy.create(key, this.publisher, this.entityCallbacks, this.context, this.converter, this.dialect, this.queryMappingConfiguration, this.operations, this.beanFactory));
    }

    public void setEntityCallbacks(EntityCallbacks entityCallbacks) {
        this.entityCallbacks = entityCallbacks;
    }

    public void setBeanFactory(@Nullable BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }
}

