/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.util;

import java.util.stream.Stream;
import org.springframework.data.gemfire.util.ArrayUtils;

public abstract class StreamUtils {
    public static <T> Stream<T> concat(Stream<T> ... streams) {
        Stream concatenatedStream = Stream.empty();
        for (Stream stream : ArrayUtils.nullSafeArray(streams, Stream.class)) {
            concatenatedStream = Stream.concat(concatenatedStream, stream);
        }
        return concatenatedStream;
    }

    public static long nullSafeCount(Stream<?> stream) {
        return StreamUtils.nullSafeStream(stream).count();
    }

    public static boolean nullSafeIsEmpty(Stream<?> stream) {
        return StreamUtils.nullSafeCount(stream) == 0L;
    }

    public static <T> Stream<T> nullSafeStream(Stream<T> stream) {
        return stream != null ? stream : Stream.empty();
    }
}

