/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.transaction.event;

import org.apache.geode.cache.TransactionEvent;
import org.apache.geode.cache.TransactionListener;
import org.apache.geode.cache.TransactionWriter;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.gemfire.transaction.event.TransactionApplicationEvent;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public class TransactionListenerAdapter
implements TransactionListener,
TransactionWriter {
    private final ApplicationEventPublisher applicationEventPublisher;

    public TransactionListenerAdapter(ApplicationEventPublisher applicationEventPublisher) {
        Assert.notNull((Object)applicationEventPublisher, (String)"ApplicationEventPublisher must not be null");
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @NonNull
    protected ApplicationEventPublisher getApplicationEventPublisher() {
        return this.applicationEventPublisher;
    }

    public void beforeCommit(TransactionEvent event) {
    }

    public void afterCommit(TransactionEvent event) {
        this.getApplicationEventPublisher().publishEvent((ApplicationEvent)TransactionApplicationEvent.of(event));
    }

    public void afterFailedCommit(TransactionEvent event) {
    }

    public void afterRollback(TransactionEvent event) {
        this.getApplicationEventPublisher().publishEvent((ApplicationEvent)TransactionApplicationEvent.of(event));
    }
}

