/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.transaction.config;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.TransactionListener;
import org.apache.geode.cache.TransactionWriter;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.Order;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.gemfire.CacheFactoryBean;
import org.springframework.data.gemfire.config.annotation.ClientCacheConfigurer;
import org.springframework.data.gemfire.config.annotation.PeerCacheConfigurer;
import org.springframework.data.gemfire.config.annotation.support.AbstractAnnotationConfigSupport;
import org.springframework.data.gemfire.transaction.GemfireTransactionManager;
import org.springframework.data.gemfire.transaction.config.EnableGemfireCacheTransactions;
import org.springframework.data.gemfire.transaction.event.ComposableTransactionWriter;
import org.springframework.data.gemfire.transaction.event.TransactionListenerAdapter;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableTransactionManagement
public class GemfireCacheTransactionsConfiguration
extends AbstractAnnotationConfigSupport
implements ImportAware {
    private volatile boolean enableAutoTransactionEventPublishing;

    @Override
    protected Class<? extends Annotation> getAnnotationType() {
        return EnableGemfireCacheTransactions.class;
    }

    public void setImportMetadata(AnnotationMetadata annotationMetadata) {
        if (this.isAnnotationPresent(annotationMetadata)) {
            AnnotationAttributes enableGemfireCacheTransactionsAttributes = this.getAnnotationAttributes(annotationMetadata);
            this.enableAutoTransactionEventPublishing = enableGemfireCacheTransactionsAttributes.getBoolean("enableAutoTransactionEventPublishing");
        }
    }

    @Bean
    public GemfireTransactionManager transactionManager(GemFireCache gemfireCache) {
        return new GemfireTransactionManager(gemfireCache);
    }

    @Bean
    @Order(value=0x7FFFFFFF)
    public ClientCacheConfigurer registerTransactionListenerAdapterClientCacheConfigurer(ApplicationEventPublisher applicationEventPublisher) {
        return (beanName, bean) -> {
            TransactionListenerAdapter transactionListener = this.newTransactionListenerAdapter(applicationEventPublisher);
            this.registerGemFireCacheTransactionEventHandlers((CacheFactoryBean)bean, transactionListener);
        };
    }

    @Bean
    @Order(value=0x7FFFFFFF)
    public PeerCacheConfigurer registerTransactionListenerAdapterPeerCacheConfigurer(ApplicationEventPublisher applicationEventPublisher) {
        return (beanName, bean) -> {
            TransactionListenerAdapter transactionListener = this.newTransactionListenerAdapter(applicationEventPublisher);
            this.registerGemFireCacheTransactionEventHandlers((CacheFactoryBean)bean, transactionListener);
        };
    }

    private TransactionListenerAdapter newTransactionListenerAdapter(ApplicationEventPublisher applicationEventPublisher) {
        return new TransactionListenerAdapter(applicationEventPublisher);
    }

    protected void registerGemFireCacheTransactionEventHandlers(CacheFactoryBean cacheFactoryBean, TransactionListenerAdapter transactionListener) {
        if (this.enableAutoTransactionEventPublishing) {
            this.registerGemFireCacheTransactionListener(cacheFactoryBean, transactionListener);
            this.registerGemFireCacheTransactionWriter(cacheFactoryBean, transactionListener);
        }
    }

    private void registerGemFireCacheTransactionListener(CacheFactoryBean bean, TransactionListener transactionListener) {
        ArrayList<TransactionListener> transactionListeners = new ArrayList<TransactionListener>(bean.getTransactionListeners());
        transactionListeners.add(transactionListener);
        bean.setTransactionListeners(transactionListeners);
    }

    private void registerGemFireCacheTransactionWriter(CacheFactoryBean bean, TransactionWriter transactionWriter) {
        TransactionWriter existingTransactionWriter = bean.getTransactionWriter();
        TransactionWriter compositeTransactionWriter = ComposableTransactionWriter.compose(existingTransactionWriter, transactionWriter);
        bean.setTransactionWriter(compositeTransactionWriter);
    }
}

