/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.support;

import java.util.Optional;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.lang.Nullable;

public abstract class AbstractFactoryBeanSupport<T>
implements FactoryBean<T>,
BeanClassLoaderAware,
BeanFactoryAware,
BeanNameAware {
    protected static final boolean DEFAULT_SINGLETON = true;
    private ClassLoader beanClassLoader;
    private BeanFactory beanFactory;
    private final Logger log = this.newLog();
    private String beanName;

    protected AbstractFactoryBeanSupport() {
    }

    protected Logger newLog() {
        return LoggerFactory.getLogger(this.getClass());
    }

    public void setBeanClassLoader(@Nullable ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    @Nullable
    public ClassLoader getBeanClassLoader() {
        return this.beanClassLoader;
    }

    public void setBeanFactory(@Nullable BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    @Nullable
    public BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void setBeanName(@Nullable String name) {
        this.beanName = name;
    }

    @Nullable
    public String getBeanName() {
        return this.beanName;
    }

    @Nullable
    protected Logger getLog() {
        return this.log;
    }

    protected Optional<Logger> getOptionalLog() {
        return Optional.ofNullable(this.getLog());
    }

    public boolean isDebugLoggingEnabled() {
        return this.getOptionalLog().filter(Logger::isInfoEnabled).isPresent();
    }

    public boolean isInfoLoggingEnabled() {
        return this.getOptionalLog().filter(Logger::isInfoEnabled).isPresent();
    }

    public boolean isErrorLoggingEnabled() {
        return this.getOptionalLog().filter(Logger::isInfoEnabled).isPresent();
    }

    public boolean isWarnLoggingEnabled() {
        return this.getOptionalLog().filter(Logger::isInfoEnabled).isPresent();
    }

    public boolean isSingleton() {
        return true;
    }

    protected void logDebug(String message, Object ... args) {
        this.logDebug(() -> String.format(message, args));
    }

    protected void logDebug(Supplier<String> message) {
        this.getOptionalLog().filter(Logger::isDebugEnabled).ifPresent(log -> log.debug((String)message.get()));
    }

    protected void logInfo(String message, Object ... args) {
        this.logInfo(() -> String.format(message, args));
    }

    protected void logInfo(Supplier<String> message) {
        this.getOptionalLog().filter(Logger::isInfoEnabled).ifPresent(log -> log.info((String)message.get()));
    }

    protected void logWarning(String message, Object ... args) {
        this.logWarning(() -> String.format(message, args));
    }

    protected void logWarning(Supplier<String> message) {
        this.getOptionalLog().filter(Logger::isWarnEnabled).ifPresent(log -> log.warn((String)message.get()));
    }

    protected void logError(String message, Object ... args) {
        this.logError(() -> String.format(message, args));
    }

    protected void logError(Supplier<String> message) {
        this.getOptionalLog().filter(Logger::isErrorEnabled).ifPresent(log -> log.error((String)message.get()));
    }
}

