/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.repository.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.data.domain.Sort;
import org.springframework.data.gemfire.mapping.annotation.Region;
import org.springframework.data.gemfire.repository.query.support.OqlKeyword;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class QueryString {
    protected static final Pattern HINT_PATTERN = Pattern.compile("<HINT '\\w+'(, '\\w+')*>");
    protected static final Pattern IMPORT_PATTERN = Pattern.compile("IMPORT .+;");
    protected static final Pattern LIMIT_PATTERN = Pattern.compile("LIMIT \\d+");
    protected static final Pattern TRACE_PATTERN = Pattern.compile("<TRACE>");
    protected static final String HINTS_OQL_TEMPLATE = "<HINT %1$s> %2$s";
    protected static final String IMPORT_OQL_TEMPLATE = "IMPORT %1$s; %2$s";
    protected static final String LIMIT_OQL_TEMPLATE = "%1$s LIMIT %2$d";
    protected static final String SELECT_OQL_TEMPLATE = "SELECT %1$s FROM /%2$s";
    protected static final String TRACE_OQL_TEMPLATE = "<TRACE> %1$s";
    protected static final String COUNT_PROJECTION = "count(*)";
    protected static final String IN_PATTERN = "(?<=IN (SET|LIST) )\\$\\d";
    protected static final String IN_PARAMETER_PATTERN = "(?<=IN (SET|LIST) \\$)\\d";
    protected static final String IN_VALUES_TEMPLATE = "(%s)";
    protected static final String REGION_PATTERN = "\\/(\\/?\\w)+";
    protected static final String STAR_PROJECTION = "*";
    @Deprecated
    protected static final String COUNT_QUERY = "count(*)";
    @Deprecated
    protected static final String STAR_QUERY = "*";
    private final String query;

    public static QueryString of(@NonNull String query) {
        return new QueryString(query);
    }

    public static QueryString from(@NonNull Class<?> domainType) {
        return new QueryString(domainType);
    }

    public static QueryString count(Class<?> domainType) {
        return new QueryString(domainType, true);
    }

    protected static String getDigitsOnly(@Nullable String value) {
        StringBuilder builder = new StringBuilder();
        if (StringUtils.hasText((String)value)) {
            for (char c : value.toCharArray()) {
                if (!Character.isDigit(c)) continue;
                builder.append(c);
            }
        }
        return builder.toString();
    }

    static String asQuery(Class<?> domainType, boolean isCountQuery) {
        return String.format(SELECT_OQL_TEMPLATE, QueryString.resolveProjection(isCountQuery), QueryString.resolveFrom(domainType));
    }

    static String resolveFrom(@NonNull Class<?> domainType) {
        return Optional.of(QueryString.validateDomainType(domainType)).filter(it -> it.isAnnotationPresent(Region.class)).map(it -> it.getAnnotation(Region.class)).map(it -> it.value()).filter(StringUtils::hasText).orElseGet(() -> domainType.getSimpleName());
    }

    @NonNull
    static String resolveProjection(boolean isCountQuery) {
        return isCountQuery ? "count(*)" : "*";
    }

    @NonNull
    static <T> Class<T> validateDomainType(@NonNull Class<T> domainType) {
        Assert.notNull(domainType, (String)"Domain type is required");
        return domainType;
    }

    @NonNull
    static String validateQuery(@NonNull String query) {
        Assert.hasText((String)query, (String)String.format("Query [%s] is required", query));
        return query;
    }

    public QueryString(@NonNull String query) {
        this.query = QueryString.validateQuery(query);
    }

    public QueryString(@NonNull Class<?> domainType) {
        this(domainType, false);
    }

    public QueryString(@NonNull Class<?> domainType, boolean asCountQuery) {
        this(QueryString.asQuery(domainType, asCountQuery));
    }

    public boolean isLimited() {
        return LIMIT_PATTERN.matcher(this.getQuery()).find();
    }

    public Iterable<Integer> getInParameterIndexes() {
        Pattern pattern = Pattern.compile(IN_PARAMETER_PATTERN);
        Matcher matcher = pattern.matcher(this.getQuery());
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        while (matcher.find()) {
            indexes.add(Integer.parseInt(matcher.group()));
        }
        return indexes;
    }

    public int getLimit() {
        String query = this.getQuery();
        Matcher matcher = LIMIT_PATTERN.matcher(query);
        if (matcher.find()) {
            int startIndex = matcher.start();
            int endIndex = matcher.end();
            String limit = query.substring(startIndex, endIndex);
            return Integer.parseInt(QueryString.getDigitsOnly(limit));
        }
        return Integer.MAX_VALUE;
    }

    @NonNull
    protected String getQuery() {
        return this.query;
    }

    public QueryString adjustLimit(@Nullable Integer limit) {
        return limit != null ? QueryString.of(LIMIT_PATTERN.matcher(this.getQuery()).replaceAll("").trim()).withLimit(limit) : this;
    }

    public QueryString asDistinct() {
        return QueryString.of(this.asDistinct(this.getQuery()));
    }

    String asDistinct(String query) {
        return query.contains(OqlKeyword.DISTINCT.getKeyword()) ? query : query.replaceFirst(OqlKeyword.SELECT.getKeyword(), String.format("%1$s %2$s", OqlKeyword.SELECT.getKeyword(), OqlKeyword.DISTINCT.getKeyword()));
    }

    @NonNull
    public QueryString bindIn(@NonNull Collection<?> values) {
        if (!CollectionUtils.nullSafeIsEmpty(values)) {
            String prefix;
            boolean isNumeric = values.stream().anyMatch(Number.class::isInstance);
            String delimiter = ", ";
            String suffix = prefix = isNumeric ? "" : "'";
            String query = this.getQuery().replaceFirst(IN_PATTERN, String.format(IN_VALUES_TEMPLATE, StringUtils.collectionToDelimitedString(values, (String)delimiter, (String)prefix, (String)suffix)));
            return QueryString.of(query);
        }
        return this;
    }

    public QueryString fromRegion(org.apache.geode.cache.Region<?, ?> region, Class<?> domainType) {
        return QueryString.of(this.getQuery().replaceAll(REGION_PATTERN, region.getFullPath()));
    }

    @Deprecated
    public QueryString fromRegion(Class<?> domainType, org.apache.geode.cache.Region<?, ?> region) {
        return this.fromRegion(region, domainType);
    }

    @NonNull
    public QueryString orderBy(@Nullable Sort sort) {
        if (this.hasSort(sort)) {
            StringBuilder orderByClause = new StringBuilder("ORDER BY ");
            int count = 0;
            for (Sort.Order order : sort) {
                orderByClause.append(count++ > 0 ? ", " : "");
                orderByClause.append(String.format("%1$s %2$s", order.getProperty(), order.getDirection()));
            }
            return new QueryString(String.format("%1$s %2$s", this.asDistinct(this.getQuery()), orderByClause.toString()));
        }
        return this;
    }

    private boolean hasSort(@Nullable Sort sort) {
        return sort != null && sort.iterator().hasNext();
    }

    @NonNull
    public QueryString withHints(String ... hints) {
        if (!ObjectUtils.isEmpty((Object[])hints)) {
            StringBuilder builder = new StringBuilder();
            for (String hint : hints) {
                builder.append(builder.length() > 0 ? ", " : "");
                builder.append(String.format("'%s'", hint));
            }
            return QueryString.of(String.format(HINTS_OQL_TEMPLATE, builder.toString(), this.getQuery()));
        }
        return this;
    }

    @NonNull
    public QueryString withImport(@NonNull String importExpression) {
        return StringUtils.hasText((String)importExpression) ? QueryString.of(String.format(IMPORT_OQL_TEMPLATE, importExpression, this.getQuery())) : this;
    }

    @NonNull
    public QueryString withLimit(@NonNull Integer limit) {
        return limit != null ? QueryString.of(String.format(LIMIT_OQL_TEMPLATE, this.getQuery(), limit)) : this;
    }

    @NonNull
    public QueryString withTrace() {
        return QueryString.of(String.format(TRACE_OQL_TEMPLATE, this.getQuery()));
    }

    public String toString() {
        return this.getQuery();
    }
}

