/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.function.execution;

import java.util.Set;
import org.apache.geode.distributed.DistributedMember;
import org.springframework.data.gemfire.function.execution.AbstractFunctionExecution;
import org.springframework.data.gemfire.function.execution.AbstractFunctionTemplate;
import org.springframework.data.gemfire.function.execution.OnAllMembersFunctionExecution;
import org.springframework.data.gemfire.function.execution.OnDistributedMembersFunctionExecution;
import org.springframework.data.gemfire.function.execution.OnMembersInGroupsFunctionExecution;

public class GemfireOnMembersFunctionTemplate
extends AbstractFunctionTemplate {
    private final Set<DistributedMember> distributedMembers;
    private final String[] groups;

    public GemfireOnMembersFunctionTemplate() {
        this.distributedMembers = null;
        this.groups = null;
    }

    public GemfireOnMembersFunctionTemplate(Set<DistributedMember> distributedMembers) {
        this.distributedMembers = distributedMembers;
        this.groups = null;
    }

    public GemfireOnMembersFunctionTemplate(String[] groups) {
        this.distributedMembers = null;
        this.groups = groups;
    }

    @Override
    protected AbstractFunctionExecution getFunctionExecution() {
        if (this.distributedMembers == null && this.groups == null) {
            return new OnAllMembersFunctionExecution();
        }
        if (this.distributedMembers == null) {
            return new OnMembersInGroupsFunctionExecution(this.groups);
        }
        return new OnDistributedMembersFunctionExecution(this.distributedMembers);
    }
}

