/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.schema;

import java.util.Arrays;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.DiskStore;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.asyncqueue.AsyncEventQueue;
import org.apache.geode.cache.client.ClientCache;
import org.apache.geode.cache.client.Pool;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.lucene.LuceneIndex;
import org.apache.geode.cache.query.Index;
import org.apache.geode.cache.wan.GatewayReceiver;
import org.apache.geode.cache.wan.GatewaySender;

public enum SchemaObjectType {
    ASYNC_EVENT_QUEUE(AsyncEventQueue.class),
    CACHE(Cache.class),
    CLIENT_CACHE(ClientCache.class),
    DISK_STORE(DiskStore.class),
    FUNCTION(Function.class),
    GATEWAY_RECEIVER(GatewayReceiver.class),
    GATEWAY_SENDER(GatewaySender.class),
    INDEX(Index.class),
    LUCENE_INDEX(LuceneIndex.class),
    POOL(Pool.class),
    REGION(Region.class),
    UNKNOWN(Void.class);

    private final Class<?> objectType;

    private SchemaObjectType(Class<?> objectType) {
        this.objectType = objectType;
    }

    public static SchemaObjectType from(Object obj) {
        return Arrays.stream(SchemaObjectType.values()).filter(it -> it.getObjectType().isInstance(obj)).findFirst().orElse(UNKNOWN);
    }

    public static SchemaObjectType from(Class<?> type) {
        return Arrays.stream(SchemaObjectType.values()).filter(it -> type != null && it.getObjectType().isAssignableFrom(type)).findFirst().orElse(UNKNOWN);
    }

    public Class<?> getObjectType() {
        return this.objectType;
    }
}

