/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.client;

import java.util.Optional;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.client.ClientCache;
import org.apache.geode.cache.client.Pool;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@FunctionalInterface
public interface PoolResolver {
    public static final String DEFAULT_POOL_NAME = "DEFAULT";

    @Nullable
    default public Pool resolve(@Nullable ClientCache clientCache) {
        return clientCache != null ? clientCache.getDefaultPool() : null;
    }

    @Nullable
    default public Pool resolve(@Nullable Region<?, ?> region) {
        return Optional.ofNullable(region).map(Region::getAttributes).map(RegionAttributes::getPoolName).filter(StringUtils::hasText).map(this::resolve).orElse(null);
    }

    @Nullable
    public Pool resolve(@Nullable String var1);

    @NonNull
    default public Pool require(@NonNull String poolName) {
        Pool pool = this.resolve(poolName);
        Assert.state((pool != null ? 1 : 0) != 0, () -> String.format("Pool with name [%s] not found", poolName));
        return pool;
    }
}

