/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.StreamSupport;
import org.springframework.data.gemfire.PeerRegionFactoryBean;
import org.springframework.data.gemfire.ResolvableRegionFactoryBean;
import org.springframework.data.gemfire.client.ClientRegionFactoryBean;
import org.springframework.data.gemfire.config.annotation.RegionConfigurer;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.util.CollectionUtils;

public abstract class ConfigurableRegionFactoryBean<K, V>
extends ResolvableRegionFactoryBean<K, V> {
    private List<RegionConfigurer> regionConfigurers = Collections.emptyList();
    private final RegionConfigurer compositeRegionConfigurer = new RegionConfigurer(){

        @Override
        public void configure(String beanName, ClientRegionFactoryBean<?, ?> bean) {
            CollectionUtils.nullSafeCollection(ConfigurableRegionFactoryBean.this.regionConfigurers).forEach(regionConfigurer -> regionConfigurer.configure(beanName, bean));
        }

        @Override
        public void configure(String beanName, PeerRegionFactoryBean<?, ?> bean) {
            CollectionUtils.nullSafeCollection(ConfigurableRegionFactoryBean.this.regionConfigurers).forEach(regionConfigurer -> regionConfigurer.configure(beanName, bean));
        }
    };

    protected RegionConfigurer getCompositeRegionConfigurer() {
        return this.compositeRegionConfigurer;
    }

    public void setRegionConfigurers(RegionConfigurer ... regionConfigurers) {
        this.setRegionConfigurers(Arrays.asList(ArrayUtils.nullSafeArray(regionConfigurers, RegionConfigurer.class)));
    }

    public void setRegionConfigurers(List<RegionConfigurer> regionConfigurers) {
        this.regionConfigurers = regionConfigurers != null ? regionConfigurers : Collections.emptyList();
    }

    protected void applyRegionConfigurers(String regionName) {
        this.applyRegionConfigurers(regionName, this.getCompositeRegionConfigurer());
    }

    protected void applyRegionConfigurers(String regionName, RegionConfigurer ... regionConfigurers) {
        this.applyRegionConfigurers(regionName, Arrays.asList(ArrayUtils.nullSafeArray(regionConfigurers, RegionConfigurer.class)));
    }

    protected void applyRegionConfigurers(String regionName, Iterable<RegionConfigurer> regionConfigurers) {
        if (this instanceof ClientRegionFactoryBean) {
            StreamSupport.stream(CollectionUtils.nullSafeIterable(regionConfigurers).spliterator(), false).forEach(regionConfigurer -> regionConfigurer.configure(regionName, (ClientRegionFactoryBean)this));
        } else if (this instanceof PeerRegionFactoryBean) {
            StreamSupport.stream(CollectionUtils.nullSafeIterable(regionConfigurers).spliterator(), false).forEach(regionConfigurer -> regionConfigurer.configure(regionName, (PeerRegionFactoryBean)this));
        }
    }
}

