/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.repository.query;

import org.springframework.core.convert.ConversionService;
import org.springframework.data.elasticsearch.core.ElasticsearchOperations;
import org.springframework.data.elasticsearch.core.query.BaseQuery;
import org.springframework.data.elasticsearch.core.query.StringQuery;
import org.springframework.data.elasticsearch.repository.query.AbstractElasticsearchRepositoryQuery;
import org.springframework.data.elasticsearch.repository.query.ElasticsearchParametersParameterAccessor;
import org.springframework.data.elasticsearch.repository.query.ElasticsearchQueryMethod;
import org.springframework.data.elasticsearch.repository.support.QueryStringProcessor;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.util.Assert;

public class ElasticsearchStringQuery
extends AbstractElasticsearchRepositoryQuery {
    private final String queryString;

    public ElasticsearchStringQuery(ElasticsearchQueryMethod queryMethod, ElasticsearchOperations elasticsearchOperations, String queryString, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        super(queryMethod, elasticsearchOperations, evaluationContextProvider);
        Assert.notNull((Object)queryString, (String)"Query cannot be empty");
        Assert.notNull((Object)evaluationContextProvider, (String)"ExpressionEvaluationContextProvider must not be null");
        this.queryString = queryString;
    }

    @Override
    public boolean isCountQuery() {
        return this.queryMethod.hasCountQueryAnnotation();
    }

    @Override
    protected boolean isDeleteQuery() {
        return false;
    }

    @Override
    protected boolean isExistsQuery() {
        return false;
    }

    @Override
    protected BaseQuery createQuery(ElasticsearchParametersParameterAccessor parameterAccessor) {
        ConversionService conversionService = this.elasticsearchOperations.getElasticsearchConverter().getConversionService();
        String processed = new QueryStringProcessor(this.queryString, this.queryMethod, conversionService, this.evaluationContextProvider).createQuery(parameterAccessor);
        return (BaseQuery)new StringQuery(processed).addSort(parameterAccessor.getSort());
    }
}

