/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.support;

import java.io.Serializable;
import org.springframework.data.couchbase.core.CouchbaseOperations;
import org.springframework.data.couchbase.repository.config.RepositoryOperationsMapping;
import org.springframework.data.couchbase.repository.support.CouchbaseRepositoryFactory;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.support.RepositoryFactoryBeanSupport;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.util.Assert;

public class CouchbaseRepositoryFactoryBean<T extends Repository<S, ID>, S, ID extends Serializable>
extends RepositoryFactoryBeanSupport<T, S, ID> {
    private RepositoryOperationsMapping operationsMapping;

    public CouchbaseRepositoryFactoryBean(Class<? extends T> repositoryInterface) {
        super(repositoryInterface);
    }

    public void setCouchbaseOperations(CouchbaseOperations operations) {
        this.setCouchbaseOperationsMapping(new RepositoryOperationsMapping(operations));
    }

    public void setCouchbaseOperationsMapping(RepositoryOperationsMapping mapping) {
        this.operationsMapping = mapping;
        this.setMappingContext(this.operationsMapping.getMappingContext());
    }

    protected RepositoryFactorySupport createRepositoryFactory() {
        return this.getFactoryInstance(this.operationsMapping);
    }

    protected CouchbaseRepositoryFactory getFactoryInstance(RepositoryOperationsMapping operationsMapping) {
        return new CouchbaseRepositoryFactory(operationsMapping);
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Assert.notNull((Object)this.operationsMapping, (String)"operationsMapping must not be null!");
    }
}

