/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.support;

import com.querydsl.apt.AbstractQuerydslProcessor;
import com.querydsl.apt.Configuration;
import com.querydsl.apt.DefaultConfiguration;
import com.querydsl.core.annotations.QueryEmbeddable;
import com.querydsl.core.annotations.QueryEmbedded;
import com.querydsl.core.annotations.QueryEntities;
import com.querydsl.core.annotations.QuerySupertype;
import com.querydsl.core.annotations.QueryTransient;
import java.util.Collections;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.springframework.data.couchbase.core.mapping.Document;
import org.springframework.lang.Nullable;

@SupportedAnnotationTypes(value={"com.querydsl.core.annotations.*", "org.springframework.data.couchbase.core.mapping.*"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class CouchbaseAnnotationProcessor
extends AbstractQuerydslProcessor {
    private boolean shouldLogInfo;

    protected Configuration createConfiguration(@Nullable RoundEnvironment roundEnv) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Running override createConfiguration() " + ((Object)((Object)this)).getClass().getSimpleName());
        DefaultConfiguration configuration = new DefaultConfiguration(this.processingEnv, roundEnv, Collections.emptySet(), QueryEntities.class, Document.class, QuerySupertype.class, QueryEmbeddable.class, QueryEmbedded.class, QueryTransient.class);
        configuration.setUnknownAsEmbedded(true);
        return configuration;
    }

    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.setLogInfo();
        this.logInfo("Running override process() " + ((Object)((Object)this)).getClass().getSimpleName() + " isOver: " + roundEnv.processingOver() + " annotations: " + annotations.size());
        if (roundEnv.processingOver() || annotations.size() == 0) {
            return ALLOW_OTHER_PROCESSORS_TO_CLAIM_ANNOTATIONS;
        }
        if (roundEnv.getRootElements() == null || roundEnv.getRootElements().isEmpty()) {
            this.logInfo("No sources to process");
            return ALLOW_OTHER_PROCESSORS_TO_CLAIM_ANNOTATIONS;
        }
        Configuration conf = this.createConfiguration(roundEnv);
        try {
            conf.getTypeMappings();
        }
        catch (NoClassDefFoundError cnfe) {
            this.logWarn(cnfe + " add a dependency on javax.inject:javax.inject to create querydsl classes");
            return ALLOW_OTHER_PROCESSORS_TO_CLAIM_ANNOTATIONS;
        }
        return super.process(annotations, roundEnv);
    }

    private void setLogInfo() {
        boolean hasProperty = this.processingEnv.getOptions().containsKey("querydsl.logInfo");
        if (hasProperty) {
            String val = this.processingEnv.getOptions().get("querydsl.logInfo");
            this.shouldLogInfo = Boolean.parseBoolean(val);
        }
    }

    private void logInfo(String message) {
        if (this.shouldLogInfo) {
            System.out.println("[NOTE] " + message);
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, message);
        }
    }

    private void logWarn(String message) {
        System.err.println("[WARNING] " + message);
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, message);
    }
}

