/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core;

import com.couchbase.client.core.msg.kv.DurabilityLevel;
import com.couchbase.client.java.kv.MutateInOptions;
import com.couchbase.client.java.kv.MutateInSpec;
import com.couchbase.client.java.kv.PersistTo;
import com.couchbase.client.java.kv.ReplicateTo;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.couchbase.core.ReactiveCouchbaseTemplate;
import org.springframework.data.couchbase.core.ReactiveMutateInByIdOperation;
import org.springframework.data.couchbase.core.ReactiveTemplateSupport;
import org.springframework.data.couchbase.core.TransactionalSupport;
import org.springframework.data.couchbase.core.mapping.CouchbaseDocument;
import org.springframework.data.couchbase.core.query.OptionsBuilder;
import org.springframework.data.couchbase.core.support.PseudoArgs;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveMutateInByIdOperationSupport
implements ReactiveMutateInByIdOperation {
    private final ReactiveCouchbaseTemplate template;
    private static final Logger LOG = LoggerFactory.getLogger(ReactiveMutateInByIdOperationSupport.class);

    public ReactiveMutateInByIdOperationSupport(ReactiveCouchbaseTemplate template) {
        this.template = template;
    }

    @Override
    public <T> ReactiveMutateInByIdOperation.ReactiveMutateInById<T> mutateInById(Class<T> domainType) {
        Assert.notNull(domainType, (String)"DomainType must not be null!");
        return new ReactiveMutateInByIdSupport<T>(this.template, domainType, OptionsBuilder.getScopeFrom(domainType), OptionsBuilder.getCollectionFrom(domainType), null, OptionsBuilder.getPersistTo(domainType), OptionsBuilder.getReplicateTo(domainType), OptionsBuilder.getDurabilityLevel(domainType, this.template.getConverter()), null, this.template.support(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), false);
    }

    static class ReactiveMutateInByIdSupport<T>
    implements ReactiveMutateInByIdOperation.ReactiveMutateInById<T> {
        private final ReactiveCouchbaseTemplate template;
        private final Class<T> domainType;
        private final String scope;
        private final String collection;
        private final MutateInOptions options;
        private final PersistTo persistTo;
        private final ReplicateTo replicateTo;
        private final DurabilityLevel durabilityLevel;
        private final Duration expiry;
        private final ReactiveTemplateSupport support;
        private final boolean provideCas;
        private final List<String> removePaths = new ArrayList<String>();
        private final List<String> upsertPaths = new ArrayList<String>();
        private final List<String> insertPaths = new ArrayList<String>();
        private final List<String> replacePaths = new ArrayList<String>();

        ReactiveMutateInByIdSupport(ReactiveCouchbaseTemplate template, Class<T> domainType, String scope, String collection, MutateInOptions options, PersistTo persistTo, ReplicateTo replicateTo, DurabilityLevel durabilityLevel, Duration expiry, ReactiveTemplateSupport support, List<String> removePaths, List<String> upsertPaths, List<String> insertPaths, List<String> replacePaths, boolean provideCas) {
            this.template = template;
            this.domainType = domainType;
            this.scope = scope;
            this.collection = collection;
            this.options = options;
            this.persistTo = persistTo;
            this.replicateTo = replicateTo;
            this.durabilityLevel = durabilityLevel;
            this.expiry = expiry;
            this.support = support;
            this.removePaths.addAll(removePaths);
            this.upsertPaths.addAll(upsertPaths);
            this.insertPaths.addAll(insertPaths);
            this.replacePaths.addAll(replacePaths);
            this.provideCas = provideCas;
        }

        @Override
        public Mono<T> one(T object) {
            PseudoArgs<MutateInOptions> pArgs = new PseudoArgs<MutateInOptions>(this.template, this.scope, this.collection, this.options, this.domainType);
            if (LOG.isDebugEnabled()) {
                LOG.debug("upsertById object={} {}", object, pArgs);
            }
            Mono reactiveEntity = TransactionalSupport.verifyNotInTransaction("mutateInById").then(this.support.encodeEntity(object)).flatMap(converted -> Mono.just((Object)this.template.getCouchbaseClientFactory().withScope(pArgs.getScope()).getCollection(pArgs.getCollection())).flatMap(collection -> collection.reactive().mutateIn(converted.getId().toString(), this.getMutations((CouchbaseDocument)converted), this.buildMutateInOptions((MutateInOptions)pArgs.getOptions(), object, (CouchbaseDocument)converted)).flatMap(result -> this.support.applyResult(object, (CouchbaseDocument)converted, converted.getId(), result.cas(), null, null))));
            return reactiveEntity.onErrorMap(throwable -> {
                if (throwable instanceof RuntimeException) {
                    return this.template.potentiallyConvertRuntimeException((RuntimeException)throwable);
                }
                return throwable;
            });
        }

        @Override
        public Flux<? extends T> all(Collection<? extends T> objects) {
            return Flux.fromIterable(objects).flatMap(this::one);
        }

        @Override
        public ReactiveMutateInByIdOperation.TerminatingMutateInById<T> withOptions(MutateInOptions options) {
            Assert.notNull((Object)options, (String)"Options must not be null.");
            return new ReactiveMutateInByIdSupport<T>(this.template, this.domainType, this.scope, this.collection, options, this.persistTo, this.replicateTo, this.durabilityLevel, this.expiry, this.support, this.removePaths, this.upsertPaths, this.insertPaths, this.replacePaths, this.provideCas);
        }

        @Override
        public ReactiveMutateInByIdOperation.MutateInByIdWithDurability<T> inCollection(String collection) {
            return new ReactiveMutateInByIdSupport<T>(this.template, this.domainType, this.scope, collection != null ? collection : this.collection, this.options, this.persistTo, this.replicateTo, this.durabilityLevel, this.expiry, this.support, this.removePaths, this.upsertPaths, this.insertPaths, this.replacePaths, this.provideCas);
        }

        @Override
        public ReactiveMutateInByIdOperation.MutateInByIdInCollection<T> inScope(String scope) {
            return new ReactiveMutateInByIdSupport<T>(this.template, this.domainType, scope != null ? scope : this.scope, this.collection, this.options, this.persistTo, this.replicateTo, this.durabilityLevel, this.expiry, this.support, this.removePaths, this.upsertPaths, this.insertPaths, this.replacePaths, this.provideCas);
        }

        @Override
        public ReactiveMutateInByIdOperation.MutateInByIdInScope<T> withDurability(DurabilityLevel durabilityLevel) {
            Assert.notNull((Object)durabilityLevel, (String)"Durability Level must not be null.");
            return new ReactiveMutateInByIdSupport<T>(this.template, this.domainType, this.scope, this.collection, this.options, this.persistTo, this.replicateTo, durabilityLevel, this.expiry, this.support, this.removePaths, this.upsertPaths, this.insertPaths, this.replacePaths, this.provideCas);
        }

        @Override
        public ReactiveMutateInByIdOperation.MutateInByIdInScope<T> withDurability(PersistTo persistTo, ReplicateTo replicateTo) {
            Assert.notNull((Object)persistTo, (String)"PersistTo must not be null.");
            Assert.notNull((Object)replicateTo, (String)"ReplicateTo must not be null.");
            return new ReactiveMutateInByIdSupport<T>(this.template, this.domainType, this.scope, this.collection, this.options, persistTo, replicateTo, this.durabilityLevel, this.expiry, this.support, this.removePaths, this.upsertPaths, this.insertPaths, this.replacePaths, this.provideCas);
        }

        @Override
        public ReactiveMutateInByIdOperation.MutateInByIdWithDurability<T> withExpiry(Duration expiry) {
            Assert.notNull((Object)expiry, (String)"expiry must not be null.");
            return new ReactiveMutateInByIdSupport<T>(this.template, this.domainType, this.scope, this.collection, this.options, this.persistTo, this.replicateTo, this.durabilityLevel, expiry, this.support, this.removePaths, this.upsertPaths, this.insertPaths, this.replacePaths, this.provideCas);
        }

        @Override
        public ReactiveMutateInByIdOperation.MutateInByIdWithDurability<T> withRemovePaths(String ... removePaths) {
            Assert.notNull((Object)removePaths, (String)"removePaths path must not be null.");
            return new ReactiveMutateInByIdSupport<T>(this.template, this.domainType, this.scope, this.collection, this.options, this.persistTo, this.replicateTo, this.durabilityLevel, this.expiry, this.support, Arrays.asList(removePaths), this.upsertPaths, this.insertPaths, this.replacePaths, this.provideCas);
        }

        @Override
        public ReactiveMutateInByIdOperation.MutateInByIdWithDurability<T> withUpsertPaths(String ... upsertPaths) {
            Assert.notNull((Object)upsertPaths, (String)"upsertPaths path must not be null.");
            return new ReactiveMutateInByIdSupport<T>(this.template, this.domainType, this.scope, this.collection, this.options, this.persistTo, this.replicateTo, this.durabilityLevel, this.expiry, this.support, this.removePaths, Arrays.asList(upsertPaths), this.insertPaths, this.replacePaths, this.provideCas);
        }

        @Override
        public ReactiveMutateInByIdOperation.MutateInByIdWithDurability<T> withInsertPaths(String ... insertPaths) {
            Assert.notNull((Object)insertPaths, (String)"insertPaths path must not be null.");
            return new ReactiveMutateInByIdSupport<T>(this.template, this.domainType, this.scope, this.collection, this.options, this.persistTo, this.replicateTo, this.durabilityLevel, this.expiry, this.support, this.removePaths, this.upsertPaths, Arrays.asList(insertPaths), this.replacePaths, this.provideCas);
        }

        @Override
        public ReactiveMutateInByIdOperation.MutateInByIdWithDurability<T> withReplacePaths(String ... replacePaths) {
            Assert.notNull((Object)replacePaths, (String)"replacePaths path must not be null.");
            return new ReactiveMutateInByIdSupport<T>(this.template, this.domainType, this.scope, this.collection, this.options, this.persistTo, this.replicateTo, this.durabilityLevel, this.expiry, this.support, this.removePaths, this.upsertPaths, this.insertPaths, Arrays.asList(replacePaths), this.provideCas);
        }

        @Override
        public ReactiveMutateInByIdOperation.MutateInByIdWithPaths<T> withCasProvided() {
            return new ReactiveMutateInByIdSupport<T>(this.template, this.domainType, this.scope, this.collection, this.options, this.persistTo, this.replicateTo, this.durabilityLevel, this.expiry, this.support, this.removePaths, this.upsertPaths, this.insertPaths, this.replacePaths, true);
        }

        private MutateInOptions buildMutateInOptions(MutateInOptions options, T object, CouchbaseDocument doc) {
            return OptionsBuilder.buildMutateInOptions(options, this.persistTo, this.replicateTo, this.durabilityLevel, this.expiry, doc, this.provideCas ? this.support.getCas(object) : null);
        }

        private List<MutateInSpec> getMutations(CouchbaseDocument document) {
            ArrayList<MutateInSpec> mutations = new ArrayList<MutateInSpec>();
            for (String path : this.removePaths) {
                mutations.add((MutateInSpec)MutateInSpec.remove((String)path));
            }
            for (String path : this.upsertPaths) {
                mutations.add((MutateInSpec)MutateInSpec.upsert((String)path, (Object)this.getCouchbaseContent(document, path)).createPath());
            }
            for (String path : this.insertPaths) {
                mutations.add((MutateInSpec)MutateInSpec.insert((String)path, (Object)this.getCouchbaseContent(document, path)).createPath());
            }
            for (String path : this.replacePaths) {
                mutations.add((MutateInSpec)MutateInSpec.replace((String)path, (Object)this.getCouchbaseContent(document, path)));
            }
            return mutations;
        }

        private Object getCouchbaseContent(CouchbaseDocument document, String path) {
            TreeMap<String, Object> result = document.export();
            for (String node : path.split("\\.")) {
                if (!(result instanceof Map)) {
                    throw new IllegalArgumentException("Path " + path + " is not valid.");
                }
                Map map = result;
                result = map.get(node);
            }
            return result;
        }
    }
}

