/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.query;

import java.util.Iterator;
import java.util.Optional;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.couchbase.core.convert.CouchbaseConverter;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentProperty;
import org.springframework.data.couchbase.core.query.N1QLExpression;
import org.springframework.data.couchbase.core.query.Query;
import org.springframework.data.couchbase.core.query.QueryCriteria;
import org.springframework.data.couchbase.repository.query.support.N1qlUtils;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;

public class N1qlQueryCreator
extends AbstractQueryCreator<Query, QueryCriteria> {
    public static final String META_ID_PROPERTY = "id";
    public static final String META_CAS_PROPERTY = "cas";
    public static final String META_EXPIRATION_PROPERTY = "expiration";
    private final PartTree tree;
    private final ParameterAccessor accessor;
    private final MappingContext<?, CouchbasePersistentProperty> context;
    private final QueryMethod queryMethod;
    private final CouchbaseConverter converter;
    private final String bucketName;
    private final PersistentEntity entity;
    static Converter<? super CouchbasePersistentProperty, String> cvtr = new MyConverter();

    public N1qlQueryCreator(PartTree tree, ParameterAccessor accessor, QueryMethod queryMethod, CouchbaseConverter converter, String bucketName) {
        super(tree, accessor);
        this.tree = tree;
        this.accessor = accessor;
        this.context = converter.getMappingContext();
        this.queryMethod = queryMethod;
        this.converter = converter;
        this.bucketName = bucketName;
        this.entity = converter.getMappingContext().getPersistentEntity(queryMethod.getEntityInformation().getJavaType());
    }

    protected QueryCriteria create(Part part, Iterator<Object> iterator) {
        PersistentPropertyPath path = this.context.getPersistentPropertyPath(part.getProperty());
        CouchbasePersistentProperty property = (CouchbasePersistentProperty)path.getLeafProperty();
        return this.from(part, property, QueryCriteria.where(N1qlQueryCreator.addMetaIfRequired(null, (PersistentPropertyPath<CouchbasePersistentProperty>)path, property, this.entity)), iterator);
    }

    public Query createQuery() {
        Query q = (Query)this.createQuery(Optional.of(this.accessor).map(ParameterAccessor::getSort).orElse(Sort.unsorted()));
        Pageable pageable = this.accessor.getPageable();
        if (pageable.isPaged()) {
            q.skip(pageable.getOffset());
            q.limit(pageable.getPageSize());
        }
        q.distinct(this.tree.isDistinct());
        return q;
    }

    protected QueryCriteria and(Part part, QueryCriteria base, Iterator<Object> iterator) {
        if (base == null) {
            return this.create(part, (Iterator)iterator);
        }
        PersistentPropertyPath path = this.context.getPersistentPropertyPath(part.getProperty());
        CouchbasePersistentProperty property = (CouchbasePersistentProperty)path.getLeafProperty();
        return this.from(part, property, base.and(N1qlQueryCreator.addMetaIfRequired(this.bucketName, (PersistentPropertyPath<CouchbasePersistentProperty>)path, property, this.entity)), iterator);
    }

    protected QueryCriteria or(QueryCriteria base, QueryCriteria criteria) {
        return base.or(criteria);
    }

    protected Query complete(QueryCriteria criteria, Sort sort) {
        Query q = (criteria == null ? new Query() : new Query().addCriteria(criteria)).with(sort);
        return q;
    }

    private QueryCriteria from(Part part, CouchbasePersistentProperty property, QueryCriteria criteria, Iterator<Object> parameters) {
        boolean isString;
        PersistentPropertyPath<CouchbasePersistentProperty> path = N1qlUtils.getPathWithAlternativeFieldNames(this.converter, part.getProperty());
        String fieldNamePath = N1qlUtils.getDottedPathWithAlternativeFieldNames(path);
        boolean ignoreCase = false;
        Class<?> leafType = this.converter.getWriteClassFor(((CouchbasePersistentProperty)path.getLeafProperty()).getType());
        boolean bl = isString = leafType == String.class;
        if (part.shouldIgnoreCase() == Part.IgnoreCaseType.WHEN_POSSIBLE) {
            ignoreCase = isString;
        } else if (part.shouldIgnoreCase() == Part.IgnoreCaseType.ALWAYS) {
            if (!isString) {
                throw new IllegalArgumentException(String.format("Part %s must be of type String but was %s", fieldNamePath, leafType));
            }
            ignoreCase = true;
        }
        Part.Type type = part.getType();
        switch (type) {
            case GREATER_THAN: 
            case AFTER: {
                return criteria.gt(ignoreCase, parameters.next());
            }
            case GREATER_THAN_EQUAL: {
                return criteria.gte(ignoreCase, parameters.next());
            }
            case LESS_THAN: 
            case BEFORE: {
                return criteria.lt(ignoreCase, parameters.next());
            }
            case LESS_THAN_EQUAL: {
                return criteria.lte(ignoreCase, parameters.next());
            }
            case SIMPLE_PROPERTY: {
                return criteria.eq(ignoreCase, parameters.next());
            }
            case NEGATING_SIMPLE_PROPERTY: {
                return criteria.ne(ignoreCase, parameters.next());
            }
            case CONTAINING: {
                return criteria.containing(ignoreCase, parameters.next());
            }
            case NOT_CONTAINING: {
                return criteria.notContaining(ignoreCase, parameters.next());
            }
            case STARTING_WITH: {
                return criteria.startingWith(ignoreCase, parameters.next());
            }
            case ENDING_WITH: {
                return criteria.endingWith(ignoreCase, parameters.next());
            }
            case LIKE: {
                return criteria.like(ignoreCase, parameters.next());
            }
            case NOT_LIKE: {
                return criteria.notLike(ignoreCase, parameters.next());
            }
            case WITHIN: {
                return criteria.within(ignoreCase, parameters.next());
            }
            case IS_NULL: {
                return criteria.isNull();
            }
            case IS_NOT_NULL: {
                return criteria.isNotNull();
            }
            case IS_EMPTY: {
                return criteria.isNotValued();
            }
            case IS_NOT_EMPTY: {
                return criteria.isValued();
            }
            case EXISTS: {
                return criteria.isNotMissing();
            }
            case REGEX: {
                return criteria.regex(parameters.next());
            }
            case BETWEEN: {
                return criteria.between(ignoreCase, parameters.next(), parameters.next());
            }
            case IN: {
                return criteria.in(ignoreCase, parameters.next());
            }
            case NOT_IN: {
                return criteria.notIn(ignoreCase, parameters.next());
            }
            case TRUE: {
                return criteria.TRUE();
            }
            case FALSE: {
                return criteria.FALSE();
            }
        }
        throw new IllegalArgumentException("Unsupported keyword!");
    }

    public static N1QLExpression addMetaIfRequired(String bucketName, PersistentPropertyPath<CouchbasePersistentProperty> persistentPropertyPath, CouchbasePersistentProperty property, PersistentEntity entity) {
        if (entity != null && property == entity.getIdProperty()) {
            return N1QLExpression.path(N1QLExpression.meta(bucketName != null ? N1QLExpression.i(bucketName) : N1QLExpression.x("")), N1QLExpression.i(META_ID_PROPERTY));
        }
        if (property == entity.getVersionProperty()) {
            return N1QLExpression.path(N1QLExpression.meta(bucketName != null ? N1QLExpression.i(bucketName) : N1QLExpression.x("")), N1QLExpression.i(META_CAS_PROPERTY));
        }
        if (property.isExpirationProperty()) {
            return N1QLExpression.path(N1QLExpression.meta(bucketName != null ? N1QLExpression.i(bucketName) : N1QLExpression.x("")), N1QLExpression.i(META_EXPIRATION_PROPERTY));
        }
        return N1QLExpression.x(persistentPropertyPath.toDotPath(cvtr));
    }

    static class MyConverter
    implements Converter<CouchbasePersistentProperty, String> {
        MyConverter() {
        }

        public String convert(CouchbasePersistentProperty source) {
            return new StringBuilder(source.getFieldName().length() + 2).append("`").append(source.getFieldName()).append("`").toString();
        }
    }
}

