/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.query;

import java.util.Collection;
import java.util.List;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.couchbase.core.ExecutableFindByQueryOperation;
import org.springframework.data.couchbase.core.ExecutableRemoveByQueryOperation;
import org.springframework.data.couchbase.core.query.Query;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.SliceImpl;
import org.springframework.util.Assert;

@FunctionalInterface
interface CouchbaseQueryExecution {
    public Object execute(Query var1, Class<?> var2, Class<?> var3, String var4, String var5);

    public static final class PagedExecution<FindWithQuery>
    implements CouchbaseQueryExecution {
        private final ExecutableFindByQueryOperation.ExecutableFindByQuery<?> operation;
        private final Pageable pageable;

        public PagedExecution(ExecutableFindByQueryOperation.ExecutableFindByQuery<?> operation, Pageable pageable) {
            Assert.notNull(operation, (String)"Operation must not be null!");
            Assert.notNull((Object)pageable, (String)"Pageable must not be null!");
            this.operation = operation;
            this.pageable = pageable;
        }

        @Override
        public Object execute(Query query, Class<?> type, Class<?> returnType, String scope, String collection) {
            int overallLimit = 0;
            Object matching = this.operation.as(returnType).inScope(scope).inCollection(collection).matching(query);
            if (overallLimit != 0 && this.pageable.getOffset() + (long)this.pageable.getPageSize() > (long)overallLimit) {
                query.limit((int)((long)overallLimit - this.pageable.getOffset()));
            }
            Collection result = matching.all();
            long count = this.operation.inScope(scope).inCollection(collection).matching(query.skip(-1L).limit(-1).withoutSort()).count();
            count = overallLimit != 0 ? Math.min(count, (long)overallLimit) : count;
            return new PageImpl((List)result, this.pageable, count);
        }
    }

    public static final class SlicedExecution
    implements CouchbaseQueryExecution {
        private final ExecutableFindByQueryOperation.ExecutableFindByQuery<?> operation;
        private final Pageable pageable;

        public SlicedExecution(ExecutableFindByQueryOperation.ExecutableFindByQuery operation, Pageable pageable) {
            Assert.notNull((Object)operation, (String)"Find must not be null!");
            Assert.notNull((Object)pageable, (String)"Pageable must not be null!");
            this.operation = operation;
            this.pageable = pageable;
        }

        @Override
        public Object execute(Query query, Class<?> type, Class<?> returnType, String scope, String collection) {
            Collection results;
            int overallLimit = 0;
            Object matching = this.operation.as(returnType).inScope(scope).inCollection(collection).matching(query);
            if (overallLimit != 0 && this.pageable.getOffset() + (long)this.pageable.getPageSize() > (long)overallLimit) {
                query.limit((int)((long)overallLimit - this.pageable.getOffset()));
            }
            return new SliceImpl((List)results, this.pageable, (results = matching.all()) != null && !results.isEmpty());
        }
    }

    public static final class ResultProcessingExecution
    implements CouchbaseQueryExecution {
        private final CouchbaseQueryExecution delegate;
        private final Converter<Object, Object> converter;

        public ResultProcessingExecution(CouchbaseQueryExecution delegate, Converter<Object, Object> converter) {
            Assert.notNull((Object)delegate, (String)"Delegate must not be null!");
            Assert.notNull(converter, (String)"Converter must not be null!");
            this.delegate = delegate;
            this.converter = converter;
        }

        @Override
        public Object execute(Query query, Class<?> type, Class<?> returnType, String scope, String collection) {
            return this.converter.convert(this.delegate.execute(query, type, returnType, scope, collection));
        }
    }

    public static final class DeleteExecution<T>
    implements CouchbaseQueryExecution {
        private final ExecutableRemoveByQueryOperation.ExecutableRemoveByQuery<T> removeOperation;

        public DeleteExecution(ExecutableRemoveByQueryOperation.ExecutableRemoveByQuery<T> removeOperation) {
            this.removeOperation = removeOperation;
        }

        @Override
        public Object execute(Query query, Class<?> type, Class<?> returnType, String scope, String collection) {
            return this.removeOperation.inScope(scope).inCollection(collection).matching(query).all();
        }
    }
}

