/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.cnc.CbTracing;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.msg.kv.DurabilityLevel;
import com.couchbase.client.core.transaction.CoreTransactionAttemptContext;
import com.couchbase.client.core.transaction.support.SpanWrapper;
import com.couchbase.client.java.AsyncCollection;
import com.couchbase.client.java.kv.InsertOptions;
import com.couchbase.client.java.kv.PersistTo;
import com.couchbase.client.java.kv.ReplicateTo;
import com.couchbase.client.java.transactions.internal.ConverterUtil;
import java.time.Duration;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.couchbase.core.ReactiveCouchbaseTemplate;
import org.springframework.data.couchbase.core.ReactiveInsertByIdOperation;
import org.springframework.data.couchbase.core.ReactiveTemplateSupport;
import org.springframework.data.couchbase.core.TransactionalSupport;
import org.springframework.data.couchbase.core.mapping.CouchbaseDocument;
import org.springframework.data.couchbase.core.query.OptionsBuilder;
import org.springframework.data.couchbase.core.support.PseudoArgs;
import org.springframework.data.couchbase.transaction.CouchbaseResourceHolder;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveInsertByIdOperationSupport
implements ReactiveInsertByIdOperation {
    private final ReactiveCouchbaseTemplate template;
    private static final Logger LOG = LoggerFactory.getLogger(ReactiveInsertByIdOperationSupport.class);

    public ReactiveInsertByIdOperationSupport(ReactiveCouchbaseTemplate template) {
        this.template = template;
    }

    @Override
    public <T> ReactiveInsertByIdOperation.ReactiveInsertById<T> insertById(Class<T> domainType) {
        Assert.notNull(domainType, (String)"DomainType must not be null!");
        return new ReactiveInsertByIdSupport<T>(this.template, domainType, OptionsBuilder.getScopeFrom(domainType), OptionsBuilder.getCollectionFrom(domainType), null, OptionsBuilder.getPersistTo(domainType), OptionsBuilder.getReplicateTo(domainType), OptionsBuilder.getDurabilityLevel(domainType, this.template.getConverter()), null, this.template.support());
    }

    static class ReactiveInsertByIdSupport<T>
    implements ReactiveInsertByIdOperation.ReactiveInsertById<T> {
        private final ReactiveCouchbaseTemplate template;
        private final Class<T> domainType;
        private final String scope;
        private final String collection;
        private final InsertOptions options;
        private final PersistTo persistTo;
        private final ReplicateTo replicateTo;
        private final DurabilityLevel durabilityLevel;
        private final Duration expiry;
        private final ReactiveTemplateSupport support;

        ReactiveInsertByIdSupport(ReactiveCouchbaseTemplate template, Class<T> domainType, String scope, String collection, InsertOptions options, PersistTo persistTo, ReplicateTo replicateTo, DurabilityLevel durabilityLevel, Duration expiry, ReactiveTemplateSupport support) {
            this.template = template;
            this.domainType = domainType;
            this.scope = scope;
            this.collection = collection;
            this.options = options;
            this.persistTo = persistTo;
            this.replicateTo = replicateTo;
            this.durabilityLevel = durabilityLevel;
            this.expiry = expiry;
            this.support = support;
        }

        @Override
        public Mono<T> one(T object) {
            PseudoArgs<InsertOptions> pArgs = new PseudoArgs<InsertOptions>(this.template, this.scope, this.collection, this.options, this.domainType);
            if (LOG.isDebugEnabled()) {
                LOG.debug("insertById object={} {}", object, pArgs);
            }
            return Mono.just((Object)this.template.getCouchbaseClientFactory().withScope(pArgs.getScope()).getCollection(pArgs.getCollection())).flatMap(collection -> this.support.encodeEntity(object).flatMap(converted -> TransactionalSupport.checkForTransactionInThreadLocalStorage().flatMap(ctxOpt -> {
                if (!ctxOpt.isPresent()) {
                    return collection.reactive().insert(converted.getId().toString(), converted.export(), this.buildOptions((InsertOptions)pArgs.getOptions(), (CouchbaseDocument)converted)).flatMap(result -> this.support.applyResult(object, (CouchbaseDocument)converted, converted.getId(), result.cas(), null, null));
                }
                this.rejectInvalidTransactionalOptions();
                CoreTransactionAttemptContext internal = ((CouchbaseResourceHolder)((Object)((Object)((Object)((Object)ctxOpt.get()))))).getCore();
                RequestSpan span = CbTracing.newSpan((CoreContext)internal.core().context(), (String)"transaction_insert", (RequestSpan)internal.span());
                span.attribute("db.operation", "transaction_insert");
                return internal.insert(ConverterUtil.makeCollectionIdentifier((AsyncCollection)collection.async()), converted.getId().toString(), this.template.getCouchbaseClientFactory().getCluster().environment().transcoder().encode(converted.export()).encoded(), new SpanWrapper(span)).flatMap(result -> this.support.applyResult(object, (CouchbaseDocument)converted, converted.getId(), result.cas(), null, null));
            })).onErrorMap(throwable -> {
                if (throwable instanceof RuntimeException) {
                    return this.template.potentiallyConvertRuntimeException((RuntimeException)throwable);
                }
                return throwable;
            }));
        }

        private void rejectInvalidTransactionalOptions() {
            if (this.persistTo != null && this.persistTo != PersistTo.NONE || this.replicateTo != null && this.replicateTo != ReplicateTo.NONE) {
                throw new IllegalArgumentException("withDurability PersistTo and ReplicateTo overload is not supported in a transaction");
            }
            if (this.expiry != null) {
                throw new IllegalArgumentException("withExpiry is not supported in a transaction");
            }
            if (this.durabilityLevel != null && this.durabilityLevel != DurabilityLevel.NONE) {
                throw new IllegalArgumentException("withDurability is not supported in a transaction");
            }
            if (this.options != null) {
                throw new IllegalArgumentException("withOptions is not supported in a transaction");
            }
        }

        @Override
        public Flux<? extends T> all(Collection<? extends T> objects) {
            return Flux.fromIterable(objects).flatMap(this::one);
        }

        public InsertOptions buildOptions(InsertOptions options, CouchbaseDocument doc) {
            return OptionsBuilder.buildInsertOptions(options, this.persistTo, this.replicateTo, this.durabilityLevel, this.expiry, doc);
        }

        @Override
        public ReactiveInsertByIdOperation.TerminatingInsertById<T> withOptions(InsertOptions options) {
            Assert.notNull((Object)options, (String)"Options must not be null.");
            return new ReactiveInsertByIdSupport<T>(this.template, this.domainType, this.scope, this.collection, options, this.persistTo, this.replicateTo, this.durabilityLevel, this.expiry, this.support);
        }

        @Override
        public ReactiveInsertByIdOperation.InsertByIdInCollection<T> inScope(String scope) {
            return new ReactiveInsertByIdSupport<T>(this.template, this.domainType, scope != null ? scope : this.scope, this.collection, this.options, this.persistTo, this.replicateTo, this.durabilityLevel, this.expiry, this.support);
        }

        @Override
        public ReactiveInsertByIdOperation.InsertByIdWithOptions<T> inCollection(String collection) {
            return new ReactiveInsertByIdSupport<T>(this.template, this.domainType, this.scope, collection != null ? collection : this.collection, this.options, this.persistTo, this.replicateTo, this.durabilityLevel, this.expiry, this.support);
        }

        @Override
        public ReactiveInsertByIdOperation.InsertByIdInScope<T> withDurability(DurabilityLevel durabilityLevel) {
            Assert.notNull((Object)durabilityLevel, (String)"Durability Level must not be null.");
            return new ReactiveInsertByIdSupport<T>(this.template, this.domainType, this.scope, this.collection, this.options, this.persistTo, this.replicateTo, durabilityLevel, this.expiry, this.support);
        }

        @Override
        public ReactiveInsertByIdOperation.InsertByIdInScope<T> withDurability(PersistTo persistTo, ReplicateTo replicateTo) {
            Assert.notNull((Object)persistTo, (String)"PersistTo must not be null.");
            Assert.notNull((Object)replicateTo, (String)"ReplicateTo must not be null.");
            return new ReactiveInsertByIdSupport<T>(this.template, this.domainType, this.scope, this.collection, this.options, persistTo, replicateTo, this.durabilityLevel, this.expiry, this.support);
        }

        @Override
        public ReactiveInsertByIdOperation.InsertByIdWithDurability<T> withExpiry(Duration expiry) {
            Assert.notNull((Object)expiry, (String)"expiry must not be null.");
            return new ReactiveInsertByIdSupport<T>(this.template, this.domainType, this.scope, this.collection, this.options, this.persistTo, this.replicateTo, this.durabilityLevel, expiry, this.support);
        }
    }
}

