/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.couchbase.core.ReactiveCouchbaseTemplate;
import org.springframework.data.couchbase.core.ReactiveTemplateSupport;
import org.springframework.data.couchbase.core.convert.CouchbaseConverter;
import org.springframework.data.couchbase.core.convert.join.N1qlJoinResolver;
import org.springframework.data.couchbase.core.convert.translation.TranslationService;
import org.springframework.data.couchbase.core.mapping.CouchbaseDocument;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentEntity;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentProperty;
import org.springframework.data.couchbase.core.mapping.event.AfterSaveEvent;
import org.springframework.data.couchbase.core.mapping.event.BeforeConvertEvent;
import org.springframework.data.couchbase.core.mapping.event.BeforeSaveEvent;
import org.springframework.data.couchbase.core.mapping.event.CouchbaseMappingEvent;
import org.springframework.data.couchbase.core.mapping.event.ReactiveAfterConvertCallback;
import org.springframework.data.couchbase.core.mapping.event.ReactiveBeforeConvertCallback;
import org.springframework.data.couchbase.repository.support.MappingCouchbaseEntityInformation;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.callback.ReactiveEntityCallbacks;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

class ReactiveCouchbaseTemplateSupport
implements ApplicationContextAware,
ReactiveTemplateSupport {
    private static final Logger LOG = LoggerFactory.getLogger(ReactiveCouchbaseTemplateSupport.class);
    private final ReactiveCouchbaseTemplate template;
    private final CouchbaseConverter converter;
    private final MappingContext<? extends CouchbasePersistentEntity<?>, CouchbasePersistentProperty> mappingContext;
    private final TranslationService translationService;
    private ReactiveEntityCallbacks reactiveEntityCallbacks;
    private ApplicationContext applicationContext;

    public ReactiveCouchbaseTemplateSupport(ReactiveCouchbaseTemplate template, CouchbaseConverter converter, TranslationService translationService) {
        this.template = template;
        this.converter = converter;
        this.mappingContext = converter.getMappingContext();
        this.translationService = translationService;
    }

    @Override
    public Mono<CouchbaseDocument> encodeEntity(Object entityToEncode) {
        return Mono.just((Object)entityToEncode).doOnNext(entity -> this.maybeEmitEvent(new BeforeConvertEvent<Object>(entity))).flatMap(entity -> this.maybeCallBeforeConvert(entity, "")).map(maybeNewEntity -> {
            CouchbaseDocument converted = new CouchbaseDocument();
            this.converter.write(maybeNewEntity, converted);
            return converted;
        }).flatMap(converted -> this.maybeCallAfterConvert((Object)entityToEncode, (CouchbaseDocument)converted, "").thenReturn(converted)).doOnNext(converted -> this.maybeEmitEvent(new BeforeSaveEvent<Object>(entityToEncode, (CouchbaseDocument)converted)));
    }

    @Override
    public <T> Mono<T> decodeEntity(String id, String source, long cas, Class<T> entityClass) {
        return Mono.fromSupplier(() -> {
            CouchbaseDocument converted = new CouchbaseDocument(id);
            converted.setId(id);
            CouchbasePersistentEntity persistentEntity = (CouchbasePersistentEntity)this.mappingContext.getRequiredPersistentEntity(entityClass);
            if (cas != 0L && persistentEntity.getVersionProperty() != null) {
                converted.put(((CouchbasePersistentProperty)persistentEntity.getVersionProperty()).getName(), cas);
            }
            Object readEntity = this.converter.read(entityClass, (CouchbaseDocument)this.translationService.decode(source, converted));
            ConvertingPropertyAccessor<Object> accessor = this.getPropertyAccessor(readEntity);
            if (persistentEntity.getVersionProperty() != null) {
                accessor.setProperty(persistentEntity.getVersionProperty(), (Object)cas);
            }
            N1qlJoinResolver.handleProperties(persistentEntity, accessor, this.template, id);
            return accessor.getBean();
        });
    }

    public Mono<Object> applyUpdatedCas(Object entity, CouchbaseDocument converted, long cas) {
        return Mono.fromSupplier(() -> {
            Object returnValue;
            ConvertingPropertyAccessor<Object> accessor = this.getPropertyAccessor(entity);
            CouchbasePersistentEntity persistentEntity = (CouchbasePersistentEntity)this.mappingContext.getRequiredPersistentEntity(entity.getClass());
            CouchbasePersistentProperty versionProperty = (CouchbasePersistentProperty)persistentEntity.getVersionProperty();
            if (versionProperty != null) {
                accessor.setProperty((PersistentProperty)versionProperty, (Object)cas);
                returnValue = accessor.getBean();
            } else {
                returnValue = entity;
            }
            this.maybeEmitEvent(new AfterSaveEvent<Object>(returnValue, converted));
            return returnValue;
        });
    }

    public Mono<Object> applyUpdatedId(Object entity, Object id) {
        return Mono.fromSupplier(() -> {
            ConvertingPropertyAccessor<Object> accessor = this.getPropertyAccessor(entity);
            CouchbasePersistentEntity persistentEntity = (CouchbasePersistentEntity)this.mappingContext.getRequiredPersistentEntity(entity.getClass());
            CouchbasePersistentProperty idProperty = (CouchbasePersistentProperty)persistentEntity.getIdProperty();
            if (idProperty != null) {
                accessor.setProperty((PersistentProperty)idProperty, id);
                return accessor.getBean();
            }
            return entity;
        });
    }

    @Override
    public Long getCas(Object entity) {
        Object casObject;
        ConvertingPropertyAccessor<Object> accessor = this.getPropertyAccessor(entity);
        CouchbasePersistentEntity persistentEntity = (CouchbasePersistentEntity)this.mappingContext.getRequiredPersistentEntity(entity.getClass());
        CouchbasePersistentProperty versionProperty = (CouchbasePersistentProperty)persistentEntity.getVersionProperty();
        long cas = 0L;
        if (versionProperty != null && (casObject = accessor.getProperty((PersistentProperty)versionProperty)) instanceof Number) {
            cas = ((Number)casObject).longValue();
        }
        return cas;
    }

    @Override
    public String getJavaNameForEntity(Class<?> clazz) {
        CouchbasePersistentEntity persistentEntity = (CouchbasePersistentEntity)this.mappingContext.getRequiredPersistentEntity(clazz);
        MappingCouchbaseEntityInformation info = new MappingCouchbaseEntityInformation(persistentEntity);
        return info.getJavaType().getName();
    }

    private <T> ConvertingPropertyAccessor<T> getPropertyAccessor(T source) {
        CouchbasePersistentEntity entity = (CouchbasePersistentEntity)this.mappingContext.getRequiredPersistentEntity(source.getClass());
        PersistentPropertyAccessor accessor = entity.getPropertyAccessor(source);
        return new ConvertingPropertyAccessor(accessor, this.converter.getConversionService());
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        if (this.reactiveEntityCallbacks == null) {
            this.setReactiveEntityCallbacks(ReactiveEntityCallbacks.create((BeanFactory)applicationContext));
        }
    }

    public void setReactiveEntityCallbacks(ReactiveEntityCallbacks reactiveEntityCallbacks) {
        Assert.notNull((Object)reactiveEntityCallbacks, (String)"EntityCallbacks must not be null!");
        this.reactiveEntityCallbacks = reactiveEntityCallbacks;
    }

    @Override
    public void maybeEmitEvent(CouchbaseMappingEvent<?> event) {
        if (this.canPublishEvent()) {
            try {
                this.applicationContext.publishEvent(event);
            }
            catch (Exception e) {
                LOG.warn("{} thrown during {}", (Object)e, event);
                throw e;
            }
        } else {
            LOG.info("maybeEmitEvent called, but ReactiveCouchbaseTemplate not initialized with applicationContext");
        }
    }

    private boolean canPublishEvent() {
        return this.applicationContext != null;
    }

    protected <T> Mono<T> maybeCallBeforeConvert(T object, String collection) {
        if (this.reactiveEntityCallbacks != null) {
            return this.reactiveEntityCallbacks.callback(ReactiveBeforeConvertCallback.class, object, new Object[]{collection});
        }
        LOG.info("maybeCallBeforeConvert called, but ReactiveCouchbaseTemplate not initialized with applicationContext");
        return Mono.just(object);
    }

    protected <T> Mono<T> maybeCallAfterConvert(T object, CouchbaseDocument document, String collection) {
        if (null != this.reactiveEntityCallbacks) {
            return this.reactiveEntityCallbacks.callback(ReactiveAfterConvertCallback.class, object, new Object[]{document, collection});
        }
        LOG.info("maybeCallAfterConvert called, but ReactiveCouchbaseTemplate not initialized with applicationContext");
        return Mono.just(object);
    }
}

