/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.domain;

import java.io.Serializable;
import org.springframework.data.domain.Range;
import org.springframework.data.domain.ScoringFunction;
import org.springframework.data.domain.UnspecifiedScoringFunction;
import org.springframework.util.ObjectUtils;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public class Score
implements Serializable {
    private final double value;
    private final ScoringFunction function;

    Score(double value, ScoringFunction function) {
        this.value = value;
        this.function = function;
    }

    public static Score of(double score) {
        return Score.of(score, ScoringFunction.unspecified());
    }

    public static Score of(double score, ScoringFunction function) {
        return new Score(score, function);
    }

    public static Range<Score> between(Score min, Score max) {
        return Range.from(Range.Bound.inclusive(min)).to(Range.Bound.inclusive(max));
    }

    public double getValue() {
        return this.value;
    }

    public ScoringFunction getFunction() {
        return this.function;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Score)) {
            return false;
        }
        Score other = (Score)o;
        if (this.value != other.value) {
            return false;
        }
        return ObjectUtils.nullSafeEquals((Object)this.function, (Object)other.function);
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHash((Object[])new Object[]{this.value, this.function});
    }

    public String toString() {
        return this.function instanceof UnspecifiedScoringFunction ? Double.toString(this.value) : "%s (%s)".formatted(Double.toString(this.value), this.function.getName());
    }
}

