/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.query;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.springframework.data.repository.core.RepositoryCreationException;
import org.springframework.data.repository.query.QueryMethod;

public final class QueryCreationException
extends RepositoryCreationException {
    private static final long serialVersionUID = -1238456123580L;
    private final Method method;

    private QueryCreationException(String message, QueryMethod method) {
        super(message, method.getMetadata().getRepositoryInterface());
        this.method = method.getMethod();
    }

    private QueryCreationException(String message, @Nullable Throwable cause, QueryMethod method) {
        super(message, cause, method.getMetadata().getRepositoryInterface());
        this.method = method.getMethod();
    }

    private QueryCreationException(@Nullable String message, @Nullable Throwable cause, Class<?> repositoryInterface, Method method) {
        super(message, cause, repositoryInterface);
        this.method = method;
    }

    public static QueryCreationException invalidProperty(QueryMethod method, String propertyName) {
        return new QueryCreationException("Could not find property '%s' on domain class '%s'".formatted(propertyName, method.getDomainClass().getName()), method);
    }

    public static QueryCreationException create(QueryMethod method, String message) {
        return new QueryCreationException(message, method);
    }

    public static QueryCreationException create(QueryMethod method, Throwable cause) {
        return new QueryCreationException(cause.getMessage(), cause, method);
    }

    public static QueryCreationException create(QueryMethod method, String message, Throwable cause) {
        return QueryCreationException.create(message, cause, method.getMetadata().getRepositoryInterface(), method.getMethod());
    }

    public static QueryCreationException create(@Nullable String message, @Nullable Throwable cause, Class<?> repositoryInterface, Method method) {
        return new QueryCreationException(message, cause, repositoryInterface, method);
    }

    public Method getMethod() {
        return this.method;
    }

    public String getLocalizedMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.method.getDeclaringClass().getSimpleName()).append('.');
        sb.append(this.method.getName());
        sb.append(this.method.getName());
        sb.append(Arrays.stream(this.method.getParameterTypes()).map(Type::getTypeName).collect(Collectors.joining(",", "(", ")")));
        return "Cannot create query for method [%s]; %s".formatted(sb.toString(), this.getMessage());
    }
}

