/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.config;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.springframework.data.repository.config.AotRepositoryInformation;
import org.springframework.data.repository.config.RepositoryConfiguration;
import org.springframework.data.repository.config.RepositoryConfigurationExtension;
import org.springframework.data.repository.config.RepositoryConfigurationExtensionSupport;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.AbstractRepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryFactoryBeanSupport;
import org.springframework.data.repository.core.support.RepositoryFragment;
import org.springframework.data.repository.core.support.RepositoryFragmentsContributor;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

class RepositoryBeanDefinitionReader {
    private final RootBeanDefinition beanDefinition;
    private final ConfigurableListableBeanFactory beanFactory;
    private final ClassLoader beanClassLoader;
    private final @Nullable RepositoryConfiguration<?> configuration;
    private final @Nullable RepositoryConfigurationExtensionSupport extension;

    public RepositoryBeanDefinitionReader(RegisteredBean bean) {
        this.beanDefinition = bean.getMergedBeanDefinition();
        this.beanFactory = bean.getBeanFactory();
        this.beanClassLoader = bean.getBeanClass().getClassLoader();
        this.configuration = (RepositoryConfiguration)this.beanDefinition.getAttribute(RepositoryConfiguration.class.getName());
        this.extension = (RepositoryConfigurationExtensionSupport)this.beanDefinition.getAttribute(RepositoryConfigurationExtension.class.getName());
    }

    public @Nullable RepositoryConfiguration<?> getConfiguration() {
        return this.configuration;
    }

    public @Nullable RepositoryConfigurationExtensionSupport getConfigurationExtension() {
        return this.extension;
    }

    public RepositoryInformation getRepositoryInformation() {
        Assert.notNull(this.configuration, (String)"Configuration must not be null");
        RepositoryMetadata metadata = AbstractRepositoryMetadata.getMetadata(this.forName(this.configuration.getRepositoryInterface()));
        Class<?> repositoryBaseClass = this.getRepositoryBaseClass();
        ArrayList fragments = new ArrayList();
        fragments.addAll(this.readRepositoryFragments());
        fragments.addAll(this.readContributedRepositoryFragments(metadata));
        RepositoryFragment<?> customImplementation = this.getCustomImplementation();
        if (customImplementation != null) {
            fragments.add(0, customImplementation);
        }
        return new AotRepositoryInformation(metadata, repositoryBaseClass, fragments);
    }

    private @Nullable RepositoryFragment<?> getCustomImplementation() {
        MutablePropertyValues mpv = this.beanDefinition.getPropertyValues();
        PropertyValue customImplementation = mpv.getPropertyValue("customImplementation");
        if (customImplementation != null) {
            Object customImplementationBean;
            Object object = customImplementation.getValue();
            if (object instanceof RuntimeBeanReference) {
                RuntimeBeanReference rbr = (RuntimeBeanReference)object;
                customImplementationBean = this.beanFactory.getBeanDefinition(rbr.getBeanName());
                Class<?> beanType = this.getClass((BeanDefinition)customImplementationBean);
                return RepositoryFragment.structural(beanType);
            }
            customImplementationBean = customImplementation.getValue();
            if (customImplementationBean instanceof BeanDefinition) {
                BeanDefinition bd = (BeanDefinition)customImplementationBean;
                Class<?> beanType = this.getClass(bd);
                return RepositoryFragment.structural(beanType);
            }
        }
        return null;
    }

    private Class<?> getRepositoryBaseClass() {
        Object repoBaseClassName = this.beanDefinition.getPropertyValues().get("repositoryBaseClass");
        if (repoBaseClassName != null) {
            return this.forName(repoBaseClassName.toString());
        }
        return Dummy.class;
    }

    private List<RepositoryFragment<?>> readRepositoryFragments() {
        RuntimeBeanReference beanReference = (RuntimeBeanReference)this.beanDefinition.getPropertyValues().get("repositoryFragments");
        BeanDefinition fragments = this.beanFactory.getBeanDefinition(beanReference.getBeanName());
        ConstructorArgumentValues.ValueHolder fragmentBeanNameList = fragments.getConstructorArgumentValues().getArgumentValue(0, List.class);
        List fragmentBeanNames = (List)fragmentBeanNameList.getValue();
        ArrayList fragmentList = new ArrayList();
        for (String beanName : fragmentBeanNames) {
            Object object;
            BeanDefinition fragmentBeanDefinition = this.beanFactory.getBeanDefinition(beanName);
            ConstructorArgumentValues cv = fragmentBeanDefinition.getConstructorArgumentValues();
            ConstructorArgumentValues.ValueHolder interfaceClassVh = cv.getArgumentValue(0, String.class);
            ConstructorArgumentValues.ValueHolder implementationVh = cv.getArgumentValue(1, null, null, null);
            Object fragmentClassName = interfaceClassVh.getValue();
            Class<?> interfaceClass = this.forName(fragmentClassName.toString());
            if (implementationVh != null && (object = implementationVh.getValue()) instanceof RuntimeBeanReference) {
                RuntimeBeanReference rbf = (RuntimeBeanReference)object;
                BeanDefinition implBeanDef = this.beanFactory.getBeanDefinition(rbf.getBeanName());
                Class<?> implClass = this.getClass(implBeanDef);
                fragmentList.add(RepositoryFragment.structural(interfaceClass, implClass));
                continue;
            }
            fragmentList.add(RepositoryFragment.structural(interfaceClass));
        }
        return fragmentList;
    }

    private List<RepositoryFragment<?>> readContributedRepositoryFragments(RepositoryMetadata metadata) {
        RepositoryFragmentsContributor contributor = this.getFragmentsContributor(metadata.getRepositoryInterface());
        return contributor.describe(metadata).stream().toList();
    }

    private RepositoryFragmentsContributor getFragmentsContributor(Class<?> repositoryInterface) {
        Object repositoryFragmentsContributor = this.beanDefinition.getPropertyValues().get("repositoryFragmentsContributor");
        if (repositoryFragmentsContributor instanceof BeanDefinition) {
            BeanDefinition bd = (BeanDefinition)repositoryFragmentsContributor;
            return (RepositoryFragmentsContributor)BeanUtils.instantiateClass(this.getClass(bd));
        }
        Assert.state((this.beanDefinition.getBeanClassName() != null ? 1 : 0) != 0, (String)"No Repository BeanFactory set");
        Class<?> repositoryFactoryBean = this.forName(this.beanDefinition.getBeanClassName());
        Constructor<?> constructor = org.springframework.data.util.ClassUtils.getDeclaredConstructorIfAvailable(repositoryFactoryBean, Class.class);
        if (constructor == null) {
            throw new IllegalStateException("No constructor accepting Class in " + repositoryFactoryBean.getName());
        }
        RepositoryFactoryBeanSupport factoryBean = (RepositoryFactoryBeanSupport)BeanUtils.instantiateClass(constructor, (Object[])new Object[]{repositoryInterface});
        return factoryBean.getRepositoryFragmentsContributor();
    }

    private Class<?> getClass(BeanDefinition definition) {
        String beanClassName = definition.getBeanClassName();
        if (ObjectUtils.isEmpty((Object)beanClassName)) {
            throw new IllegalStateException("No bean class name specified for %s".formatted(definition));
        }
        return this.forName(beanClassName);
    }

    private Class<?> forName(String name) {
        try {
            return ClassUtils.forName((String)name, (ClassLoader)this.beanClassLoader);
        }
        catch (ClassNotFoundException cause) {
            throw new TypeNotPresentException(name, cause);
        }
    }

    static abstract class Dummy
    implements CrudRepository<Object, Object>,
    PagingAndSortingRepository<Object, Object> {
        Dummy() {
        }
    }
}

