/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.aot.generate;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import javax.lang.model.element.Modifier;
import org.jspecify.annotations.Nullable;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.ResolvableType;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.javapoet.ParameterSpec;
import org.springframework.javapoet.TypeName;
import org.springframework.util.ClassUtils;

class MethodMetadata {
    private final Map<String, ParameterSpec> methodArguments;
    private final Map<String, MethodParameter> methodParameters;
    private final Map<String, String> localVariables = new LinkedHashMap<String, String>();
    private final ResolvableType actualReturnType;
    private final ResolvableType returnType;

    MethodMetadata(RepositoryInformation repositoryInformation, Method method) {
        this.returnType = repositoryInformation.getReturnType(method).toResolvableType();
        this.actualReturnType = MethodMetadata.resolvePrimaryIfNecessary(repositoryInformation.getReturnedDomainTypeInformation(method));
        LinkedHashMap<String, ParameterSpec> methodArguments = new LinkedHashMap<String, ParameterSpec>();
        LinkedHashMap<String, MethodParameter> methodParameters = new LinkedHashMap<String, MethodParameter>();
        ResolvableType repositoryInterface = ResolvableType.forClass(repositoryInformation.getRepositoryInterface());
        DefaultParameterNameDiscoverer nameDiscoverer = new DefaultParameterNameDiscoverer();
        MethodMetadata.initializeMethodArguments(method, (ParameterNameDiscoverer)nameDiscoverer, repositoryInterface, methodArguments, methodParameters);
        this.methodArguments = Collections.unmodifiableMap(methodArguments);
        this.methodParameters = Collections.unmodifiableMap(methodParameters);
    }

    static ResolvableType resolvePrimaryIfNecessary(TypeInformation<?> type) {
        return type.getType().isPrimitive() ? ResolvableType.forType((Type)ClassUtils.resolvePrimitiveIfNecessary(type.getType())) : type.toResolvableType();
    }

    private static void initializeMethodArguments(Method method, ParameterNameDiscoverer nameDiscoverer, ResolvableType repositoryInterface, Map<String, ParameterSpec> methodArguments, Map<String, MethodParameter> methodParameters) {
        for (Parameter parameter : method.getParameters()) {
            MethodParameter methodParameter = MethodParameter.forParameter((Parameter)parameter);
            methodParameter.initParameterNameDiscovery(nameDiscoverer);
            ResolvableType resolvableParameterType = ResolvableType.forMethodParameter((MethodParameter)methodParameter, (ResolvableType)repositoryInterface);
            TypeName parameterType = TypeName.get((Type)resolvableParameterType.getType());
            ParameterSpec parameterSpec = ParameterSpec.builder((TypeName)parameterType, (String)methodParameter.getParameterName(), (Modifier[])new Modifier[0]).build();
            if (methodArguments.containsKey(parameterSpec.name())) {
                throw new IllegalStateException("Parameter with name '" + parameterSpec.name() + "' already exists.");
            }
            methodArguments.put(parameterSpec.name(), parameterSpec);
            methodParameters.put(parameterSpec.name(), methodParameter);
        }
    }

    ResolvableType getReturnType() {
        return this.returnType;
    }

    ResolvableType getActualReturnType() {
        return this.actualReturnType;
    }

    Map<String, ParameterSpec> getMethodArguments() {
        return this.methodArguments;
    }

    Map<String, MethodParameter> getMethodParameters() {
        return this.methodParameters;
    }

    @Nullable String getParameterName(int position) {
        if (0 > position) {
            return null;
        }
        ArrayList<Map.Entry<String, ParameterSpec>> entries = new ArrayList<Map.Entry<String, ParameterSpec>>(this.methodArguments.entrySet());
        if (position < entries.size()) {
            return (String)((Map.Entry)entries.get(position)).getKey();
        }
        return null;
    }

    public String getOrCreateLocalVariable(String variableName, Function<? super String, ? extends String> mappingFunction) {
        return this.localVariables.computeIfAbsent(variableName, mappingFunction);
    }
}

