/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.util;

import java.lang.reflect.Constructor;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.springframework.util.Assert;

public abstract class ClassUtils {
    private ClassUtils() {
    }

    public static void ifPresent(String className, @Nullable ClassLoader classLoader, Consumer<Class<?>> action) {
        try {
            Class theClass = org.springframework.util.ClassUtils.forName((String)className, (ClassLoader)classLoader);
            action.accept(theClass);
        }
        catch (IllegalAccessError err) {
            throw new IllegalStateException("Readability mismatch in inheritance hierarchy of class [" + className + "]: " + err.getMessage(), err);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static @Nullable Class<?> loadIfPresent(String name, @Nullable ClassLoader classLoader) {
        try {
            return org.springframework.util.ClassUtils.forName((String)name, (ClassLoader)classLoader);
        }
        catch (Exception o_O) {
            return null;
        }
    }

    public static <T> @Nullable Constructor<T> getDeclaredConstructorIfAvailable(Class<T> clazz, Class<?> ... paramTypes) {
        Assert.notNull(clazz, (String)"Class must not be null");
        try {
            return clazz.getDeclaredConstructor(paramTypes);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }
}

