/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.aot.generate;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import org.springframework.data.repository.aot.generate.AotQueryMethodGenerationContext;
import org.springframework.javapoet.CodeBlock;
import org.springframework.javapoet.MethodSpec;
import org.springframework.javapoet.TypeName;
import org.springframework.javapoet.TypeVariableName;
import org.springframework.util.StringUtils;

class AotRepositoryMethodBuilder {
    private final AotQueryMethodGenerationContext context;
    private Function<AotQueryMethodGenerationContext, CodeBlock> contribution = context -> CodeBlock.builder().build();
    private BiConsumer<AotQueryMethodGenerationContext, MethodSpec.Builder> customizer = (context, body) -> {};

    AotRepositoryMethodBuilder(AotQueryMethodGenerationContext context2) {
        this.context = context2;
    }

    public AotRepositoryMethodBuilder contribute(Function<AotQueryMethodGenerationContext, CodeBlock> contribution) {
        this.contribution = contribution;
        return this;
    }

    public AotRepositoryMethodBuilder customize(BiConsumer<AotQueryMethodGenerationContext, MethodSpec.Builder> customizer) {
        this.customizer = customizer;
        return this;
    }

    public MethodSpec buildMethod() {
        TypeVariable<Method>[] tvs;
        CodeBlock methodBody = this.contribution.apply(this.context);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)this.context.getMethod().getName()).addModifiers(new Modifier[]{Modifier.PUBLIC});
        builder.returns(TypeName.get((Type)this.context.getReturnType().getType()));
        for (TypeVariable<Method> tv : tvs = this.context.getMethod().getTypeParameters()) {
            builder.addTypeVariable(TypeVariableName.get(tv));
        }
        builder.addJavadoc("AOT generated implementation of {@link $T#$L($L)}.", new Object[]{this.context.getMethod().getDeclaringClass(), this.context.getMethod().getName(), StringUtils.collectionToCommaDelimitedString((Collection)this.context.getTargetMethodMetadata().getMethodArguments().values().stream().map(it -> it.type.toString()).collect(Collectors.toList()))});
        this.context.getTargetMethodMetadata().getMethodArguments().forEach((name, spec) -> builder.addParameter(spec));
        builder.addCode(methodBody);
        this.customizer.accept(this.context, builder);
        return builder.build();
    }
}

