/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.domain;

import java.util.Arrays;
import java.util.Collection;
import org.springframework.data.domain.DoubleVector;
import org.springframework.data.domain.Vector;
import org.springframework.util.ObjectUtils;

class FloatVector
implements Vector {
    static final FloatVector EMPTY = new FloatVector(new float[0]){

        @Override
        public float[] toFloatArray() {
            return this.v;
        }

        @Override
        public double[] toDoubleArray() {
            return DoubleVector.EMPTY.v;
        }
    };
    final float[] v;

    FloatVector(float[] v) {
        this.v = v;
    }

    static Vector copy(float[] v) {
        if (v.length == 0) {
            return EMPTY;
        }
        return new FloatVector(Arrays.copyOf(v, v.length));
    }

    static Vector copy(Collection<? extends Number> v) {
        if (v.isEmpty()) {
            return EMPTY;
        }
        float[] copy = new float[v.size()];
        int i = 0;
        for (Number number : v) {
            copy[i++] = number.floatValue();
        }
        return new FloatVector(copy);
    }

    public Class<Float> getType() {
        return Float.TYPE;
    }

    @Override
    public Object getSource() {
        return this.v;
    }

    @Override
    public int size() {
        return this.v.length;
    }

    @Override
    public float[] toFloatArray() {
        return Arrays.copyOf(this.v, this.v.length);
    }

    @Override
    public double[] toDoubleArray() {
        double[] copy = new double[this.v.length];
        for (int i = 0; i < this.v.length; ++i) {
            copy[i] = this.v[i];
        }
        return copy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FloatVector)) {
            return false;
        }
        FloatVector that = (FloatVector)o;
        return ObjectUtils.nullSafeEquals((Object)this.v, (Object)that.v);
    }

    public int hashCode() {
        return Arrays.hashCode(this.v);
    }

    public String toString() {
        return "F" + Arrays.toString(this.v);
    }
}

