/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.querydsl.binding;

import com.querydsl.core.types.Path;
import com.querydsl.core.types.dsl.CollectionPathBase;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import org.springframework.beans.BeanUtils;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.querydsl.EntityPathResolver;
import org.springframework.data.querydsl.binding.PathInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;

record PropertyPathInformation(PropertyPath path) implements PathInformation
{
    public static PropertyPathInformation of(String path, Class<?> type) {
        return PropertyPathInformation.of(PropertyPath.from(path, type));
    }

    public static PropertyPathInformation of(String path, TypeInformation<?> type) {
        return PropertyPathInformation.of(PropertyPath.from(path, type));
    }

    private static PropertyPathInformation of(PropertyPath path) {
        return new PropertyPathInformation(path);
    }

    @Override
    public Class<?> getRootParentType() {
        return this.path.getOwningType().getType();
    }

    @Override
    public Class<?> getLeafType() {
        return this.path.getLeafProperty().getType();
    }

    @Override
    public Class<?> getLeafParentType() {
        return this.path.getLeafProperty().getOwningType().getType();
    }

    @Override
    public String getLeafProperty() {
        return this.path.getLeafProperty().getSegment();
    }

    @Override
    @Nullable
    public PropertyDescriptor getLeafPropertyDescriptor() {
        return BeanUtils.getPropertyDescriptor(this.getLeafParentType(), (String)this.getLeafProperty());
    }

    @Override
    public String toDotPath() {
        return this.path.toDotPath();
    }

    @Override
    public Path<?> reifyPath(EntityPathResolver resolver) {
        return PropertyPathInformation.reifyPath(resolver, this.path, null);
    }

    private static Path<?> reifyPath(EntityPathResolver resolver, PropertyPath path, @Nullable Path<?> base) {
        if (base instanceof CollectionPathBase) {
            return PropertyPathInformation.reifyPath(resolver, path, (Path)((CollectionPathBase)base).any());
        }
        Path<?> entityPath = base != null ? base : resolver.createPath(path.getOwningType().getType());
        Field field = ReflectionUtils.findField(entityPath.getClass(), (String)path.getSegment());
        Object value = ReflectionUtils.getField((Field)field, entityPath);
        if (path.hasNext()) {
            return PropertyPathInformation.reifyPath(resolver, path.next(), (Path)value);
        }
        return (Path)value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PathInformation)) {
            return false;
        }
        PathInformation that = (PathInformation)o;
        return ObjectUtils.nullSafeEquals(this.getRootParentType(), that.getRootParentType()) && ObjectUtils.nullSafeEquals((Object)this.toDotPath(), (Object)that.toDotPath());
    }

    @Override
    public int hashCode() {
        int result = ObjectUtils.nullSafeHashCode(this.getRootParentType());
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.toDotPath());
        return result;
    }

    @Override
    public String toString() {
        return "PropertyPathInformation(path=" + String.valueOf(this.path) + ")";
    }
}

