/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.query;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.spi.EvaluationContextExtension;
import org.springframework.data.repository.query.spi.Function;
import org.springframework.data.spel.ExtensionAwareEvaluationContextProvider;
import org.springframework.data.util.Lazy;
import org.springframework.data.util.Streamable;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class ExtensionAwareQueryMethodEvaluationContextProvider
implements QueryMethodEvaluationContextProvider {
    private final Lazy<ExtensionAwareEvaluationContextProvider> delegate;

    public ExtensionAwareQueryMethodEvaluationContextProvider(ListableBeanFactory beanFactory) {
        Assert.notNull((Object)beanFactory, (String)"ListableBeanFactory must not be null!");
        this.delegate = Lazy.of(() -> {
            ExtensionAwareEvaluationContextProvider delegate = new ExtensionAwareEvaluationContextProvider(() -> ExtensionAwareQueryMethodEvaluationContextProvider.getExtensionsFrom(beanFactory));
            delegate.setBeanFactory(beanFactory);
            return delegate;
        });
    }

    public ExtensionAwareQueryMethodEvaluationContextProvider(List<? extends org.springframework.data.spel.spi.EvaluationContextExtension> extensions) {
        Assert.notNull(extensions, (String)"EvaluationContextExtensions must not be null!");
        this.delegate = Lazy.of(new ExtensionAwareEvaluationContextProvider(extensions));
    }

    @Override
    public <T extends Parameters<?, ?>> EvaluationContext getEvaluationContext(T parameters, Object[] parameterValues) {
        StandardEvaluationContext evaluationContext = this.delegate.get().getEvaluationContext(parameterValues);
        evaluationContext.setVariables(ExtensionAwareQueryMethodEvaluationContextProvider.collectVariables(parameters, parameterValues));
        return evaluationContext;
    }

    private static Map<String, Object> collectVariables(Streamable<? extends Parameter> parameters, Object[] arguments) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        parameters.stream().filter(Parameter::isSpecialParameter).forEach(it -> variables.put(StringUtils.uncapitalize((String)it.getType().getSimpleName()), arguments[it.getIndex()]));
        parameters.stream().filter(Parameter::isNamedParameter).forEach(it -> variables.put(it.getName().orElseThrow(() -> new IllegalStateException("Should never occur!")), arguments[it.getIndex()]));
        return variables;
    }

    private static List<org.springframework.data.spel.spi.EvaluationContextExtension> getExtensionsFrom(ListableBeanFactory beanFactory) {
        Stream<org.springframework.data.spel.spi.EvaluationContextExtension> legacyExtensions = beanFactory.getBeansOfType(EvaluationContextExtension.class, true, false).values().stream().map(ExtensionAwareQueryMethodEvaluationContextProvider::adaptFromLegacyApi);
        Stream extensions = beanFactory.getBeansOfType(org.springframework.data.spel.spi.EvaluationContextExtension.class, true, false).values().stream();
        return Stream.concat(extensions, legacyExtensions).collect(Collectors.toList());
    }

    private static final org.springframework.data.spel.spi.EvaluationContextExtension adaptFromLegacyApi(EvaluationContextExtension extension) {
        DelegatingMethodInterceptor advice = new DelegatingMethodInterceptor(extension);
        advice.registerResultMapping("getFunctions", result -> ((Map)result).entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> ((Function)e.getValue()).toNewFunction())));
        ProxyFactory factory = new ProxyFactory();
        factory.setInterfaces(new Class[]{org.springframework.data.spel.spi.EvaluationContextExtension.class});
        factory.setTargetClass(extension.getClass());
        factory.setProxyTargetClass(true);
        factory.setTarget((Object)extension);
        factory.addAdvice((Advice)advice);
        return (org.springframework.data.spel.spi.EvaluationContextExtension)factory.getProxy();
    }

    static class DelegatingMethodInterceptor
    implements MethodInterceptor {
        private static final Map<Method, Method> METHOD_CACHE = new ConcurrentReferenceHashMap();
        private final Object target;
        private final Map<String, java.util.function.Function<Object, Object>> directMappings = new HashMap<String, java.util.function.Function<Object, Object>>();

        public void registerResultMapping(String methodName, java.util.function.Function<Object, Object> mapping) {
            this.directMappings.put(methodName, mapping);
        }

        @Nullable
        public Object invoke(@Nullable MethodInvocation invocation) throws Throwable {
            Method targetMethod;
            Object result;
            if (invocation == null) {
                throw new IllegalArgumentException("Invocation must not be null!");
            }
            Method method = invocation.getMethod();
            Object object = result = method.equals(targetMethod = METHOD_CACHE.computeIfAbsent(method, it -> Optional.ofNullable(this.findTargetMethod((Method)it)).orElse((Method)it))) ? invocation.proceed() : ReflectionUtils.invokeMethod((Method)targetMethod, (Object)this.target, (Object[])invocation.getArguments());
            if (result == null) {
                return result;
            }
            java.util.function.Function<Object, Object> mapper = this.directMappings.get(targetMethod.getName());
            return mapper != null ? mapper.apply(result) : result;
        }

        @Nullable
        private Method findTargetMethod(Method method) {
            try {
                return this.target.getClass().getMethod(method.getName(), method.getParameterTypes());
            }
            catch (Exception e) {
                return null;
            }
        }

        public DelegatingMethodInterceptor(Object target) {
            this.target = target;
        }
    }
}

