/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;

public interface PersistentProperty<P extends PersistentProperty<P>> {
    public PersistentEntity<?, P> getOwner();

    public String getName();

    public Class<?> getType();

    public TypeInformation<?> getTypeInformation();

    @Deprecated
    public Iterable<? extends TypeInformation<?>> getPersistentEntityType();

    default public Iterable<? extends TypeInformation<?>> getPersistentEntityTypes() {
        return this.getPersistentEntityType();
    }

    @Nullable
    public Method getGetter();

    default public Method getRequiredGetter() {
        Method getter = this.getGetter();
        if (getter == null) {
            throw new IllegalArgumentException("No getter available for this persistent property!");
        }
        return getter;
    }

    @Nullable
    public Method getSetter();

    default public Method getRequiredSetter() {
        Method setter = this.getSetter();
        if (setter == null) {
            throw new IllegalArgumentException("No setter available for this persistent property!");
        }
        return setter;
    }

    @Nullable
    public Field getField();

    default public Field getRequiredField() {
        Field field = this.getField();
        if (field == null) {
            throw new IllegalArgumentException("No field backing this persistent property!");
        }
        return field;
    }

    @Nullable
    public String getSpelExpression();

    @Nullable
    public Association<P> getAssociation();

    default public Association<P> getRequiredAssociation() {
        Association<P> association = this.getAssociation();
        if (association != null) {
            return association;
        }
        throw new IllegalStateException("No association found!");
    }

    public boolean isEntity();

    public boolean isIdProperty();

    public boolean isVersionProperty();

    public boolean isCollectionLike();

    public boolean isMap();

    public boolean isArray();

    public boolean isTransient();

    public boolean isWritable();

    public boolean isAssociation();

    @Nullable
    public Class<?> getComponentType();

    public Class<?> getRawType();

    @Nullable
    public Class<?> getMapValueType();

    public Class<?> getActualType();

    @Nullable
    public <A extends Annotation> A findAnnotation(Class<A> var1);

    default public <A extends Annotation> A getRequiredAnnotation(Class<A> annotationType) throws IllegalStateException {
        A annotation = this.findAnnotation(annotationType);
        if (annotation != null) {
            return annotation;
        }
        throw new IllegalStateException(String.format("Required annotation %s not found for %s!", annotationType, this.getName()));
    }

    @Nullable
    public <A extends Annotation> A findPropertyOrOwnerAnnotation(Class<A> var1);

    public boolean isAnnotationPresent(Class<? extends Annotation> var1);

    public boolean usePropertyAccess();
}

