/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping.model;

import java.beans.PropertyDescriptor;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.annotation.Reference;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public abstract class AbstractPersistentProperty<P extends PersistentProperty<P>>
implements PersistentProperty<P> {
    private static final Field CAUSE_FIELD = ReflectionUtils.findField(Throwable.class, (String)"cause");
    protected final String name;
    protected final PropertyDescriptor propertyDescriptor;
    protected final TypeInformation<?> information;
    protected final Class<?> rawType;
    protected final Field field;
    protected final Association<P> association;
    protected final PersistentEntity<?, P> owner;
    private final SimpleTypeHolder simpleTypeHolder;
    private final int hashCode;

    public AbstractPersistentProperty(Field field, PropertyDescriptor propertyDescriptor, PersistentEntity<?, P> owner, SimpleTypeHolder simpleTypeHolder) {
        Assert.notNull((Object)simpleTypeHolder, (String)"SimpleTypeHolder must not be null!");
        Assert.notNull(owner, (String)"Owner entity must not be null!");
        this.propertyDescriptor = propertyDescriptor;
        this.field = field;
        this.owner = owner;
        this.simpleTypeHolder = simpleTypeHolder;
        this.name = field == null ? propertyDescriptor.getName() : field.getName();
        this.information = owner.getTypeInformation().getProperty(this.name);
        this.rawType = this.information != null ? this.information.getType() : (field == null ? propertyDescriptor.getPropertyType() : field.getType());
        this.association = this.isAssociation() ? this.createAssociation() : null;
        this.hashCode = this.field == null ? this.propertyDescriptor.hashCode() : this.field.hashCode();
    }

    protected abstract Association<P> createAssociation();

    @Override
    public PersistentEntity<?, P> getOwner() {
        return this.owner;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<?> getType() {
        return this.information.getType();
    }

    @Override
    public Class<?> getRawType() {
        return this.rawType;
    }

    @Override
    public TypeInformation<?> getTypeInformation() {
        return this.information;
    }

    @Override
    public Iterable<? extends TypeInformation<?>> getPersistentEntityType() {
        if (!this.isEntity()) {
            return Collections.emptySet();
        }
        TypeInformation<?> candidate = this.getTypeInformationIfEntityCandidate();
        return candidate != null ? Collections.singleton(candidate) : Collections.emptySet();
    }

    private TypeInformation<?> getTypeInformationIfEntityCandidate() {
        TypeInformation<?> candidate = this.information.getActualType();
        if (candidate == null || this.simpleTypeHolder.isSimpleType(candidate.getType())) {
            return null;
        }
        return candidate.isCollectionLike() || candidate.isMap() ? null : candidate;
    }

    @Override
    public Method getGetter() {
        if (this.propertyDescriptor == null) {
            return null;
        }
        Method getter = this.propertyDescriptor.getReadMethod();
        if (getter == null) {
            return null;
        }
        Class<?> returnType = this.owner.getTypeInformation().getReturnType(getter).getType();
        return this.rawType.isAssignableFrom(returnType) ? getter : null;
    }

    @Override
    public Method getSetter() {
        if (this.propertyDescriptor == null) {
            return null;
        }
        Method setter = this.propertyDescriptor.getWriteMethod();
        if (setter == null) {
            return null;
        }
        Class<?> parameterType = this.owner.getTypeInformation().getParameterTypes(setter).get(0).getType();
        return parameterType.isAssignableFrom(this.rawType) ? setter : null;
    }

    @Override
    public Field getField() {
        return this.field;
    }

    @Override
    public String getSpelExpression() {
        return null;
    }

    @Override
    public boolean isTransient() {
        return false;
    }

    @Override
    public boolean isWritable() {
        return !this.isTransient();
    }

    @Override
    public boolean isAssociation() {
        return this.field == null ? false : AnnotationUtils.getAnnotation((AnnotatedElement)this.field, Reference.class) != null;
    }

    @Override
    public Association<P> getAssociation() {
        return this.association;
    }

    @Override
    public boolean isCollectionLike() {
        return this.information.isCollectionLike();
    }

    @Override
    public boolean isMap() {
        return Map.class.isAssignableFrom(this.getType());
    }

    @Override
    public boolean isArray() {
        return this.getType().isArray();
    }

    @Override
    public boolean isEntity() {
        return !this.isTransient() && this.getTypeInformationIfEntityCandidate() != null;
    }

    @Override
    public Class<?> getComponentType() {
        if (!this.isMap() && !this.isCollectionLike()) {
            return null;
        }
        TypeInformation<?> componentType = this.information.getComponentType();
        return componentType == null ? null : componentType.getType();
    }

    @Override
    public Class<?> getMapValueType() {
        return this.isMap() ? this.information.getMapValueType().getType() : null;
    }

    @Override
    public Class<?> getActualType() {
        return this.information.getActualType().getType();
    }

    @Override
    public boolean usePropertyAccess() {
        return this.owner.getType().isInterface() || CAUSE_FIELD.equals(this.getField());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AbstractPersistentProperty)) {
            return false;
        }
        AbstractPersistentProperty that = (AbstractPersistentProperty)obj;
        return this.field == null ? this.propertyDescriptor.equals(that.propertyDescriptor) : this.field.equals(that.field);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.field == null ? this.propertyDescriptor.toString() : this.field.toString();
    }
}

