/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Map;
import org.springframework.data.util.ParentTypeAwareTypeInformation;
import org.springframework.data.util.TypeDiscoverer;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

class TypeVariableTypeInformation<T>
extends ParentTypeAwareTypeInformation<T> {
    private final TypeVariable<?> variable;
    private final Type owningType;

    public TypeVariableTypeInformation(TypeVariable<?> variable, Type owningType, TypeDiscoverer<?> parent, Map<TypeVariable<?>, Type> typeVariableMap) {
        super(variable, parent, typeVariableMap);
        Assert.notNull(variable, (String)"TypeVariable must not be null!");
        this.variable = variable;
        this.owningType = owningType;
    }

    @Override
    public Class<T> getType() {
        int index = this.getIndex(this.variable);
        if (this.owningType instanceof ParameterizedType && index != -1) {
            Type fieldType = ((ParameterizedType)this.owningType).getActualTypeArguments()[index];
            return this.resolveType(fieldType);
        }
        return this.resolveType(this.variable);
    }

    private int getIndex(TypeVariable<?> variable) {
        Class rawType = this.resolveType(this.owningType);
        TypeVariable<Class<S>>[] typeParameters = rawType.getTypeParameters();
        for (int i = 0; i < typeParameters.length; ++i) {
            if (!variable.equals(typeParameters[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TypeVariableTypeInformation)) {
            return false;
        }
        TypeVariableTypeInformation that = (TypeVariableTypeInformation)obj;
        return this.getType().equals(that.getType());
    }

    @Override
    public int hashCode() {
        int result = 17;
        return result += 31 * ObjectUtils.nullSafeHashCode(this.getType());
    }

    public String toString() {
        return this.variable.getName();
    }
}

